/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.utilities;

import edu.iu.sci2.utilities.FAQCalendar;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;

public class DateUtilities {
    public static final double AVERAGE_MILLIS_PER_MONTH = 2.629728E9;
    private static final DateFormat[] ACCEPTED_DATE_FORMATS = new DateFormat[]{DateFormat.getDateInstance(0), new SimpleDateFormat("d-MM-yy"), new SimpleDateFormat("d-MM-yyyy"), new SimpleDateFormat("dd-MM-yy"), new SimpleDateFormat("dd-MM-yyyy"), new SimpleDateFormat("d/MM/yy"), new SimpleDateFormat("dd/MM/yy"), new SimpleDateFormat("d/MM/yyyy"), new SimpleDateFormat("dd/MMM/yyyy"), new SimpleDateFormat("d-MMM-yy"), new SimpleDateFormat("d-MMM-yyyy"), new SimpleDateFormat("dd-MMM-yy"), new SimpleDateFormat("dd-MMM-yyyy"), new SimpleDateFormat("d/MMM/yy"), new SimpleDateFormat("dd/MMM/yy"), new SimpleDateFormat("d/MMM/yyyy"), new SimpleDateFormat("dd/MMM/yyyy"), new SimpleDateFormat("yyyy"), DateFormat.getDateInstance(3), DateFormat.getDateInstance(2), DateFormat.getDateInstance(1)};

    public static Date[] generateDaysBetweenDates(Date startDate, Date endDate) {
        GregorianCalendar startDateCalendar = new GregorianCalendar(startDate.getYear() + 1900, startDate.getMonth(), startDate.getDate());
        GregorianCalendar endDateCalendar = new GregorianCalendar(endDate.getYear() + 1900, endDate.getMonth(), endDate.getDate());
        if (startDateCalendar.getTimeInMillis() > endDateCalendar.getTimeInMillis()) {
            return new Date[0];
        }
        ArrayList<Date> workingDaysBetweenDates = new ArrayList<Date>();
        GregorianCalendar currentCalendarForDateThatWeAreCalculating = (GregorianCalendar)startDateCalendar.clone();
        Date actualEndDateAccordingToCalendar = endDateCalendar.getTime();
        boolean shouldKeepGeneratingDaysBetweenDates = true;
        while (shouldKeepGeneratingDaysBetweenDates) {
            Date currentCalculatedDate = currentCalendarForDateThatWeAreCalculating.getTime();
            workingDaysBetweenDates.add(currentCalculatedDate);
            currentCalendarForDateThatWeAreCalculating.add(5, 1);
            if (currentCalculatedDate.getYear() != actualEndDateAccordingToCalendar.getYear() || currentCalculatedDate.getMonth() != actualEndDateAccordingToCalendar.getMonth() || currentCalculatedDate.getDate() != actualEndDateAccordingToCalendar.getDate()) continue;
            shouldKeepGeneratingDaysBetweenDates = false;
        }
        Date[] finalDaysBetweenDates = new Date[workingDaysBetweenDates.size()];
        return workingDaysBetweenDates.toArray(finalDaysBetweenDates);
    }

    public static int calculateDaysBetween(Date[] dateSet) {
        return dateSet.length;
    }

    public static int calculateDaysBetween(Date startDate, Date endDate) {
        FAQCalendar startDateCalendar = new FAQCalendar(startDate.getYear(), startDate.getMonth(), startDate.getDate());
        FAQCalendar endDateCalendar = new FAQCalendar(endDate.getYear(), endDate.getMonth(), endDate.getDate());
        return (int)startDateCalendar.diffDayPeriods(endDateCalendar);
    }

    public static int calculateMonthsBetween(Date startDate, Date endDate) {
        int roundedMonthsBetween = (int)Math.round((double)(endDate.getTime() - startDate.getTime()) / 2.629728E9);
        if (roundedMonthsBetween > 0) {
            return roundedMonthsBetween;
        }
        return 1;
    }

    public static Date[] getNewYearsDatesFromDateSet(Date[] dateSet) {
        ArrayList<Date> workingNewYearsDates = new ArrayList<Date>();
        if (dateSet.length == 0) {
            return new Date[0];
        }
        if (dateSet[0].getMonth() != 0 || dateSet[0].getDate() != 1) {
            workingNewYearsDates.add(new Date(dateSet[0].getYear(), 0, 1));
        }
        int ii = 0;
        while (ii < dateSet.length) {
            if (dateSet[ii].getMonth() == 0 && dateSet[ii].getDate() == 1) {
                workingNewYearsDates.add(dateSet[ii]);
            }
            ++ii;
        }
        Date[] finalNewYearsDates = new Date[workingNewYearsDates.size()];
        return workingNewYearsDates.toArray(finalNewYearsDates);
    }

    public static Date[] generateNewYearsDatesBetweenDates(Date startDate, Date endDate) {
        int startDateYear = startDate.getYear();
        int endDateYear = endDate.getYear();
        int numYearsBetween = endDateYear - startDateYear + 1;
        if (numYearsBetween == 0) {
            return new Date[0];
        }
        Date[] newYearsDatesBetween = new Date[numYearsBetween];
        int ii = 0;
        while (ii < numYearsBetween) {
            newYearsDatesBetween[ii] = new Date(startDateYear + ii, 0, 1);
            ++ii;
        }
        return newYearsDatesBetween;
    }

    public static Date[] generateFirstOfTheMonthDatesBetweenDates(Date[] dateSet) {
        ArrayList<Date> workingFirstOfTheMonthDates = new ArrayList<Date>();
        int ii = 0;
        while (ii < dateSet.length) {
            if (dateSet[ii].getDate() == 1) {
                workingFirstOfTheMonthDates.add(dateSet[ii]);
            }
            ++ii;
        }
        Date[] finalFirstOfTheMonthDates = new Date[workingFirstOfTheMonthDates.size()];
        return workingFirstOfTheMonthDates.toArray(finalFirstOfTheMonthDates);
    }

    public static Date[] generateFirstOfTheMonthDatesBetweenDates(Date startDate, Date endDate) {
        Date[] allDaysBetweenDates = DateUtilities.generateDaysBetweenDates(startDate, endDate);
        return DateUtilities.generateFirstOfTheMonthDatesBetweenDates(allDaysBetweenDates);
    }

    public static Date parseDate(String dateString) throws ParseException {
        DateFormat[] dateFormatArray = ACCEPTED_DATE_FORMATS;
        int n = ACCEPTED_DATE_FORMATS.length;
        int n2 = 0;
        while (n2 < n) {
            DateFormat format = dateFormatArray[n2];
            try {
                format.setLenient(false);
                Date date = format.parse(dateString);
                if (date.getYear() < 1900) {
                    date.setYear(date.getYear() + 1900);
                }
                return date;
            }
            catch (ParseException parseException) {
                ++n2;
            }
        }
        String exceptionMessage = "Could not parse the field '" + dateString + "'" + " as a date.";
        throw new ParseException(exceptionMessage, 0);
    }

    public static Date interpretObjectAsDate(Object object) throws ParseException {
        String objectAsString = object.toString();
        if (object instanceof Date) {
            return (Date)object;
        }
        if (object instanceof short[]) {
            short[] year = (short[])object;
            if (year.length == 0) {
                throw new ParseException("An empty date was found.", 0);
            }
            objectAsString = "" + year[0];
        } else if (object instanceof Short[]) {
            Short[] year = (Short[])object;
            if (year.length == 0) {
                throw new ParseException("An empty date was found.", 0);
            }
            objectAsString = "" + year[0];
        } else if (object instanceof int[]) {
            int[] year = (int[])object;
            if (year.length == 0) {
                throw new ParseException("An empty date was found.", 0);
            }
            objectAsString = "" + year[0];
        } else if (object instanceof Integer[]) {
            Integer[] year = (Integer[])object;
            if (year.length == 0) {
                throw new ParseException("An empty date was found.", 0);
            }
            objectAsString = year.toString();
        } else if (object instanceof long[]) {
            long[] year = (long[])object;
            if (year.length == 0) {
                throw new ParseException("An empty date was found.", 0);
            }
            objectAsString = "" + year[0];
        } else if (object instanceof Long[]) {
            Long[] year = (Long[])object;
            if (year.length == 0) {
                throw new ParseException("An empty date was found.", 0);
            }
            objectAsString = "" + year[0];
        } else if (object instanceof String[]) {
            String[] year = (String[])object;
            if (year.length == 0) {
                throw new ParseException("An empty date was found.", 0);
            }
            objectAsString = year[0];
        }
        return DateUtilities.parseDate(objectAsString);
    }
}

