/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.utilities;

import java.util.Calendar;
import java.util.GregorianCalendar;

public class FAQCalendar
extends GregorianCalendar {
    public static final long MILLISECS_PER_MINUTE = 60000L;
    public static final long MILLISECS_PER_HOUR = 3600000L;
    protected static final long MILLISECS_PER_DAY = 86400000L;
    public static final long EPOCH_UNIX_ERA_DAY = 2440588L;

    public FAQCalendar() {
    }

    public FAQCalendar(long millisecondTime) {
        this.setTimeInMillis(millisecondTime);
    }

    public FAQCalendar(int y, int m, int d) {
        super(y, m, d);
    }

    public FAQCalendar(int y, int m, int d, int h, int min, int s) {
        super(y, m, d, h, min, s);
    }

    public long getUnixDay() {
        long offset = this.get(15) + this.get(16);
        long day = (long)Math.floor((double)(this.getTime().getTime() + offset) / 8.64E7);
        return day;
    }

    public long getJulianDay() {
        return this.getUnixDay() + 2440588L;
    }

    public long diffDayPeriods(Calendar end) {
        long endL = end.getTimeInMillis() + (long)end.getTimeZone().getOffset(end.getTimeInMillis());
        long startL = this.getTimeInMillis() + (long)this.getTimeZone().getOffset(this.getTimeInMillis());
        return (endL - startL) / 86400000L;
    }
}

