/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.utilities;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.imageio.ImageIO;

public class FileUtilities {
    private static File createTemporaryDirectory(String temporaryDirectoryPath) {
        return FileUtilities.ensureDirectoryExists(String.valueOf(temporaryDirectoryPath) + File.separator + "temp");
    }

    public static File createTemporaryFile(File temporaryDirectory, String temporaryDirectoryPath, String temporaryFileName, String temporaryFileExtension) {
        File temporaryFile;
        block4: {
            FileUtilities.ensureDirectoryExists(temporaryDirectoryPath);
            try {
                temporaryFile = File.createTempFile("NWB-Session-" + temporaryFileName, "." + temporaryFileExtension, temporaryDirectory);
            }
            catch (IOException iOException) {
                temporaryFile = new File(String.valueOf(temporaryDirectoryPath) + File.separator + temporaryFileName + "temp." + temporaryFileExtension);
                if (temporaryFile.exists()) break block4;
                try {
                    temporaryFile.createNewFile();
                }
                catch (IOException e2) {
                    throw new RuntimeException(e2);
                }
                temporaryFile.deleteOnExit();
            }
        }
        return temporaryFile;
    }

    public static File createTemporaryFileInTemporaryDirectory(String temporaryDirectoryPath, String temporaryFileName, String temporaryFileExtension) throws IOException {
        File temporaryDirectory = FileUtilities.createTemporaryDirectory(temporaryDirectoryPath);
        File temporaryFile = FileUtilities.createTemporaryFile(temporaryDirectory, temporaryDirectoryPath, temporaryFileName, temporaryFileExtension);
        if (temporaryFile == null) {
            throw new IOException("Failed to generate a file in the temporary directory.");
        }
        return temporaryFile;
    }

    public static String getDefaultTemporaryDirectory() {
        return System.getProperty("java.io.tmpdir");
    }

    public static File createTemporaryFileInDefaultTemporaryDirectory(String temporaryFileName, String temporaryFileExtension) throws IOException {
        return FileUtilities.createTemporaryFileInTemporaryDirectory(FileUtilities.getDefaultTemporaryDirectory(), temporaryFileName, temporaryFileExtension);
    }

    public static File writeBufferedImageIntoTemporaryDirectory(BufferedImage bufferedImage, String imageType) throws IOException, Exception {
        String temporaryDirectoryPath = FileUtilities.getDefaultTemporaryDirectory();
        File temporaryImageFile = FileUtilities.createTemporaryFileInTemporaryDirectory(temporaryDirectoryPath, "nwb-temp", imageType);
        if (!ImageIO.write((RenderedImage)bufferedImage, imageType, temporaryImageFile)) {
            throw new Exception("No valid image writer was found for the image type " + imageType);
        }
        return temporaryImageFile;
    }

    public static File writeTextIntoTemporaryDirectory(String text, String fileExtension) throws IOException, Exception {
        String temporaryDirectoryPath = FileUtilities.getDefaultTemporaryDirectory();
        File temporaryTextFile = FileUtilities.createTemporaryFileInTemporaryDirectory(temporaryDirectoryPath, "nwb-temp", fileExtension);
        FileWriter textFileWriter = new FileWriter(temporaryTextFile);
        textFileWriter.write(text);
        textFileWriter.flush();
        return temporaryTextFile;
    }

    private static File ensureDirectoryExists(String directoryPath) {
        File directory = new File(directoryPath);
        if (!directory.exists()) {
            directory.mkdir();
            directory.deleteOnExit();
        }
        return directory;
    }
}

