/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.utilities;

import edu.iu.sci2.utilities.ColumnNotFoundException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import prefuse.data.Schema;
import prefuse.data.Table;
import prefuse.util.collections.IntIterator;

public class TableUtilities {
    public static String[] filterSchemaColumnNamesByClass(Schema schema, Class objectClass) throws ColumnNotFoundException {
        ArrayList<String> workingColumnNames = new ArrayList<String>();
        int ii = 0;
        while (ii < schema.getColumnCount()) {
            if (objectClass.isAssignableFrom(schema.getColumnType(ii))) {
                workingColumnNames.add(schema.getColumnName(ii));
            }
            ++ii;
        }
        if (workingColumnNames.size() == 0) {
            throw new ColumnNotFoundException("No column of type " + objectClass.getName() + " was found.");
        }
        String[] finalColumnNames = new String[workingColumnNames.size()];
        return workingColumnNames.toArray(finalColumnNames);
    }

    public static List getAllColumnNames(Schema schema) throws ColumnNotFoundException {
        ArrayList<String> workingColumnNames = new ArrayList<String>();
        int ii = 0;
        while (ii < schema.getColumnCount()) {
            workingColumnNames.add(schema.getColumnName(ii));
            ++ii;
        }
        if (workingColumnNames.size() == 0) {
            throw new ColumnNotFoundException("No columns found in the schema.");
        }
        return workingColumnNames;
    }

    public static String formNonConflictingNewColumnName(Schema schema, String[] suggestedColumnNames) throws ColumnNotFoundException {
        List workingColumnNames = TableUtilities.getAllColumnNames(schema);
        boolean suggestedNameFound = false;
        int suggestedNameIndex = 0;
        while (suggestedNameIndex < suggestedColumnNames.length) {
            int i = 0;
            while (i < workingColumnNames.size()) {
                if (workingColumnNames.get(i).toString().equalsIgnoreCase(suggestedColumnNames[suggestedNameIndex])) {
                    suggestedNameFound = true;
                    break;
                }
                ++i;
            }
            if (suggestedNameFound) break;
            ++suggestedNameIndex;
        }
        if (!suggestedNameFound) {
            return suggestedColumnNames[0];
        }
        boolean newColumnNameFound = false;
        int columnNameSuffix = 2;
        while (true) {
            String newColumnName = suggestedColumnNames[0].concat("_" + columnNameSuffix);
            int i = 0;
            while (i < workingColumnNames.size()) {
                if (workingColumnNames.get(i).toString().equalsIgnoreCase(newColumnName)) {
                    newColumnNameFound = true;
                    break;
                }
                ++i;
            }
            if (!newColumnNameFound) {
                return newColumnName;
            }
            ++columnNameSuffix;
        }
    }

    public static String[] filterSchemaColumnNamesByClasses(Schema schema, Class[] objectClasses) throws ColumnNotFoundException {
        ArrayList<String> workingColumnNames = new ArrayList<String>();
        int ii = 0;
        while (ii < schema.getColumnCount()) {
            Class[] classArray = objectClasses;
            int n = objectClasses.length;
            int n2 = 0;
            while (n2 < n) {
                Class objectClass = classArray[n2];
                if (objectClass.isAssignableFrom(schema.getColumnType(ii))) {
                    workingColumnNames.add(schema.getColumnName(ii));
                    break;
                }
                ++n2;
            }
            ++ii;
        }
        if (workingColumnNames.size() > 0) {
            String[] finalColumnNames = new String[workingColumnNames.size()];
            return workingColumnNames.toArray(finalColumnNames);
        }
        StringBuffer objectClassesString = new StringBuffer();
        objectClassesString.append("[");
        int ii2 = 0;
        while (ii2 < objectClasses.length) {
            objectClassesString.append(objectClasses[ii2].getName());
            if (ii2 + 1 < objectClasses.length) {
                objectClassesString.append(", ");
            }
            ++ii2;
        }
        objectClassesString.append("]");
        throw new ColumnNotFoundException("No column of types " + objectClassesString + " was found.");
    }

    public static String[] getValidStringColumnNamesInTable(Table table) throws ColumnNotFoundException {
        return TableUtilities.filterSchemaColumnNamesByClass(table.getSchema(), String.class);
    }

    public static String[] getValidDateColumnNamesInTable(Table table) throws ColumnNotFoundException {
        Class[] possibleDateClasses = new Class[]{Date.class, Integer.TYPE, Integer.class, String.class, int[].class, Integer[].class, String[].class};
        return TableUtilities.filterSchemaColumnNamesByClasses(table.getSchema(), possibleDateClasses);
    }

    public static String[] getValidIntegerColumnNamesInTable(Table table) throws ColumnNotFoundException {
        Class[] possibleIntegerClasses = new Class[]{Integer.TYPE, Integer.class, int[].class, Integer[].class};
        return TableUtilities.filterSchemaColumnNamesByClasses(table.getSchema(), possibleIntegerClasses);
    }

    public static String[] getValidNumberColumnNamesInTable(Table table) throws ColumnNotFoundException {
        Class[] possibleNumberClasses = new Class[]{Byte.TYPE, byte[].class, Byte.class, Byte[].class, Short.TYPE, short[].class, Short.class, Short[].class, Integer.TYPE, int[].class, Integer.class, Integer[].class, Long.TYPE, long[].class, Long.class, Long[].class, Float.TYPE, float[].class, Float.class, Float[].class, Double.TYPE, double[].class, Double.class, Double[].class};
        return TableUtilities.filterSchemaColumnNamesByClasses(table.getSchema(), possibleNumberClasses);
    }

    public static Table createTableUsingSchema(Schema tableSchema) {
        int numTableColumns = tableSchema.getColumnCount();
        Table table = new Table();
        int ii = 0;
        while (ii < numTableColumns) {
            table.addColumn(tableSchema.getColumnName(ii), tableSchema.getColumnType(ii));
            ++ii;
        }
        return table;
    }

    public static void copyTableRow(int newTableRow, int originalTableRow, Table newTable, Table originalTable) {
        int numTableColumns = originalTable.getColumnCount();
        int ii = 0;
        while (ii < numTableColumns) {
            newTable.set(newTableRow, ii, originalTable.get(originalTableRow, ii));
            ++ii;
        }
    }

    public static Table copyNRowsFromTableUsingIntIterator(Table originalTable, IntIterator iterator, int topN, boolean isDescending) {
        Schema tableSchema = originalTable.getSchema();
        int numTableRows = originalTable.getRowCount();
        Table newTable = TableUtilities.createTableUsingSchema(tableSchema);
        int numRowsToCopy = Math.min(numTableRows, topN);
        int[] originalTableRowsToCopy = new int[numTableRows];
        newTable.addRows(numRowsToCopy);
        int ii = 0;
        while (ii < numTableRows) {
            originalTableRowsToCopy[ii] = iterator.nextInt();
            ++ii;
        }
        if (!isDescending) {
            ii = 0;
            while (ii < numRowsToCopy) {
                TableUtilities.copyTableRow(ii, originalTableRowsToCopy[ii], newTable, originalTable);
                ++ii;
            }
        } else {
            ii = 0;
            while (ii < numRowsToCopy) {
                TableUtilities.copyTableRow(ii, originalTableRowsToCopy[numTableRows - ii - 1], newTable, originalTable);
                ++ii;
            }
        }
        return newTable;
    }
}

