/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.bipartitenet;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import edu.iu.sci2.visualization.bipartitenet.component.NodeView;
import edu.iu.sci2.visualization.bipartitenet.component.Paintable;
import edu.iu.sci2.visualization.bipartitenet.component.PaintableContainer;
import edu.iu.sci2.visualization.bipartitenet.component.edge.ThicknessCodedEdgeView;
import edu.iu.sci2.visualization.bipartitenet.component.edge.shape.EdgeShape;
import edu.iu.sci2.visualization.bipartitenet.model.BipartiteGraphDataModel;
import edu.iu.sci2.visualization.bipartitenet.model.Edge;
import edu.iu.sci2.visualization.bipartitenet.model.Node;
import edu.iu.sci2.visualization.bipartitenet.scale.Scale;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.util.LinkedHashMap;
import math.geom2d.Point2D;
import math.geom2d.line.LineSegment2D;

public class BipartiteGraphRenderer
implements Paintable {
    private final BipartiteGraphDataModel data;
    private ImmutableMap<Node, NodeView> nodeToNodeView;
    private PaintableContainer painter = new PaintableContainer();
    private final LineSegment2D leftLine;
    private final LineSegment2D rightLine;
    private final Scale<Double, Double> nodeRadiusCoding;
    private final Scale<Double, Double> edgeCoding;
    private final int maxNodeRadius;
    private final Font[] nodeFonts;
    private final double nodeToPageEdgeDistance;
    private final EdgeShape edgeShape;

    public BipartiteGraphRenderer(BipartiteGraphDataModel skel, LineSegment2D leftLine, LineSegment2D rightLine, int maxNodeRadius, Scale<Double, Double> nodeRadiusCoding, Scale<Double, Double> edgeCoding, Font[] nodeFonts, double nodeToPageEdgeDistance, EdgeShape edgeShape) {
        this.data = skel;
        this.leftLine = leftLine;
        this.rightLine = rightLine;
        this.nodeRadiusCoding = nodeRadiusCoding;
        this.maxNodeRadius = maxNodeRadius;
        this.edgeCoding = edgeCoding;
        this.nodeFonts = nodeFonts;
        this.nodeToPageEdgeDistance = nodeToPageEdgeDistance;
        this.edgeShape = edgeShape;
        this.nodeToNodeView = ImmutableMap.copyOf(this.placeNodes());
        this.placeEdges();
    }

    private void placeEdges() {
        for (Edge e : this.data.getEdges()) {
            Preconditions.checkState((boolean)this.nodeToNodeView.containsKey((Object)e.getLeftNode()));
            Preconditions.checkState((boolean)this.nodeToNodeView.containsKey((Object)e.getRightNode()));
            ThicknessCodedEdgeView ev = new ThicknessCodedEdgeView(e, (NodeView)this.nodeToNodeView.get((Object)e.getLeftNode()), (NodeView)this.nodeToNodeView.get((Object)e.getRightNode()), this.edgeCoding, this.edgeShape);
            this.painter.insert(ev);
        }
    }

    private LinkedHashMap<Node, NodeView> placeNodes() {
        LinkedHashMap nodeViews = Maps.newLinkedHashMap();
        nodeViews.putAll(this.placeNodesOnLine(this.data.getLeftNodes(), this.getLeftLine(), this.nodeFonts[0]));
        nodeViews.putAll(this.placeNodesOnLine(this.data.getRightNodes(), this.getRightLine(), this.nodeFonts[1]));
        for (NodeView nv : nodeViews.values()) {
            this.painter.add(nv);
        }
        return nodeViews;
    }

    private LinkedHashMap<Node, NodeView> placeNodesOnLine(ImmutableList<Node> nodes, LineSegment2D centerLine, Font nodeFont) {
        LinkedHashMap nodeViews = Maps.newLinkedHashMap();
        int numNodes = nodes.size();
        double denominator = Math.max(1, numNodes - 1);
        double maxHeight = Math.min(centerLine.getLength() / denominator, (double)this.maxNodeRadius);
        int i = 0;
        while (i < numNodes) {
            Point2D centerPoint = centerLine.getPoint((double)i / denominator);
            NodeView view = new NodeView((Node)nodes.get(i), centerPoint, this.nodeRadiusCoding, maxHeight, nodeFont, this.nodeToPageEdgeDistance);
            nodeViews.put((Node)nodes.get(i), view);
            ++i;
        }
        return nodeViews;
    }

    public LineSegment2D getLeftLine() {
        return this.leftLine;
    }

    public LineSegment2D getRightLine() {
        return this.rightLine;
    }

    @Override
    public void paint(Graphics2D g) {
        g.setColor(Color.black);
        this.painter.paint(g);
    }
}

