/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.bipartitenet;

import java.io.PrintStream;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.service.log.LogService;

public enum LogStream {
    ERROR(1, System.err),
    WARNING(2, System.out),
    INFO(3, System.out),
    DEBUG(4, System.out);

    private static LogService logService;
    private final int severityLevel;
    private final transient PrintStream fallback;

    private LogStream(int severityLevel, PrintStream fallback) {
        this.severityLevel = severityLevel;
        this.fallback = fallback;
    }

    private static void setService(LogService logService) {
        LogStream.logService = logService;
    }

    public void send(String messageTemplate, Object ... templateArguments) {
        this.send(null, messageTemplate, templateArguments);
    }

    public void send(Throwable throwable, String messageTemplate, Object ... templateArguments) {
        String message = String.format(messageTemplate, templateArguments);
        if (logService != null) {
            logService.log(this.severityLevel, message, throwable);
        } else {
            this.fallback.println(String.format("%s: %s", this.toString(), message));
            if (throwable != null) {
                this.fallback.println("The exception reflecting the condition: " + throwable);
            }
        }
    }

    public static final class Activator
    implements BundleActivator {
        public void start(BundleContext context) {
            LogStream.setService((LogService)context.getService(context.getServiceReference(LogService.class.getName())));
        }

        public void stop(BundleContext context) {
            context.ungetService(context.getServiceReference(LogService.class.getName()));
            LogStream.setService(null);
        }
    }
}

