/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.bipartitenet;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import edu.iu.sci2.visualization.bipartitenet.BipartiteGraphRenderer;
import edu.iu.sci2.visualization.bipartitenet.TextType;
import edu.iu.sci2.visualization.bipartitenet.component.CircleRadiusLegend;
import edu.iu.sci2.visualization.bipartitenet.component.ComplexLabelPainter;
import edu.iu.sci2.visualization.bipartitenet.component.HowToRead;
import edu.iu.sci2.visualization.bipartitenet.component.Paintable;
import edu.iu.sci2.visualization.bipartitenet.component.PaintableContainer;
import edu.iu.sci2.visualization.bipartitenet.component.SimpleLabelPainter;
import edu.iu.sci2.visualization.bipartitenet.component.edge.EdgeWeightLegend;
import edu.iu.sci2.visualization.bipartitenet.component.edge.shape.BezierEdgeShape;
import edu.iu.sci2.visualization.bipartitenet.component.edge.shape.EdgeShape;
import edu.iu.sci2.visualization.bipartitenet.model.BipartiteGraphDataModel;
import edu.iu.sci2.visualization.bipartitenet.model.Edge;
import edu.iu.sci2.visualization.bipartitenet.model.Node;
import edu.iu.sci2.visualization.bipartitenet.model.NodeType;
import edu.iu.sci2.visualization.bipartitenet.scale.BasicZeroAnchoredScale;
import edu.iu.sci2.visualization.bipartitenet.scale.ConstantValue;
import edu.iu.sci2.visualization.bipartitenet.scale.Scale;
import edu.iu.sci2.visualization.bipartitenet.scale.ZeroAnchoredCircleRadiusScale;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import math.geom2d.Point2D;
import math.geom2d.line.LineSegment2D;

public class PageDirector
implements Paintable {
    private static final String EDGE_LEGEND_TITLE = "Weight";
    private static final String CIRCLE_LEGEND_TITLE = "Area";
    private static final String MAIN_TITLE = "Network Visualization";
    private static final String FOOTER = "CNS (cns.iu.edu)";
    public static final double LINE_SPACING = 1.2;
    private static final Font BASE_FONT = PageDirector.findBasicFont(10);
    private static final ImmutableMap<TextType, Font> PRINT_FONTS = ImmutableMap.of((Object)((Object)TextType.TITLE), (Object)BASE_FONT.deriveFont(1, 14.0f), (Object)((Object)TextType.NODE_LABEL), (Object)BASE_FONT.deriveFont(0, 12.0f), (Object)((Object)TextType.LEGEND), (Object)BASE_FONT.deriveFont(0, 10.0f), (Object)((Object)TextType.FOOTER), (Object)BASE_FONT.deriveFont(2, 10.0f), (Object)((Object)TextType.HOW_TO_READ), (Object)BASE_FONT.deriveFont(0, 10.0f));
    private static final ImmutableMap<TextType, Font> WEB_FONTS = ImmutableMap.of((Object)((Object)TextType.TITLE), (Object)BASE_FONT.deriveFont(1, 20.0f), (Object)((Object)TextType.NODE_LABEL), (Object)BASE_FONT.deriveFont(0, 16.0f), (Object)((Object)TextType.LEGEND), (Object)BASE_FONT.deriveFont(0, 14.0f), (Object)((Object)TextType.FOOTER), (Object)BASE_FONT.deriveFont(2, 10.0f), (Object)((Object)TextType.HOW_TO_READ), (Object)BASE_FONT.deriveFont(0, 14.0f));
    private static final double NODE_OVERLAP_PART = 0.5;
    private PaintableContainer painter = new PaintableContainer();
    private BipartiteGraphDataModel dataModel;
    private final Layout layout;
    private final double WHITESPACE_AMONG_LABELS = 30.0;

    public PageDirector(Layout layout, String subtitle, BipartiteGraphDataModel model, NodeType leftType, NodeType rightType) {
        this.layout = layout;
        this.dataModel = model;
        this.painter.add(this.makeSortingLegend(leftType, rightType));
        Scale<Double, Double> nodeCoding = this.makeNodeCodingAndLegend();
        Scale<Double, Double> edgeCoding = this.makeEdgeCodingAndLegend();
        if (layout.hasHowToRead()) {
            this.painter.add(new HowToRead(layout.getFont(TextType.TITLE), layout.getFont(TextType.HOW_TO_READ), layout.getHowToReadLegendPosition()));
        }
        BipartiteGraphRenderer renderer = new BipartiteGraphRenderer(this.dataModel, layout.getLeftLine(), layout.getRightLine(), layout.getMaxNodeRadius(), nodeCoding, edgeCoding, this.createNodeLabelFonts(), (double)layout.getWidth() - layout.getRightLine().getFirstPoint().getX(), layout.getEdgeShape());
        this.painter.add(renderer);
        if (layout.hasTitle()) {
            Point2D headerPosition = layout.getHeaderPosition();
            ComplexLabelPainter.Builder builder = new ComplexLabelPainter.Builder(headerPosition, layout.getFont(TextType.LEGEND), Color.BLACK).addLine(MAIN_TITLE, layout.getFont(TextType.TITLE));
            if (!subtitle.isEmpty()) {
                builder.addLine(subtitle);
            }
            this.painter.add(builder.addLine(this.getTimeStamp()).withLineSpacing(1.2).build());
        }
        this.painter.add(SimpleLabelPainter.alignedBy(SimpleLabelPainter.XAlignment.RIGHT, SimpleLabelPainter.YAlignment.BASELINE).withFont(layout.getFont(TextType.TITLE)).makeLabel(layout.getLeftTitlePosition(), leftType.getDisplayName()));
        this.painter.add(SimpleLabelPainter.alignedBy(SimpleLabelPainter.XAlignment.LEFT, SimpleLabelPainter.YAlignment.BASELINE).withFont(layout.getFont(TextType.TITLE)).makeLabel(layout.getRightTitlePosition(), rightType.getDisplayName()));
        this.painter.add(SimpleLabelPainter.alignedBy(SimpleLabelPainter.XAlignment.CENTER, SimpleLabelPainter.YAlignment.BASELINE).withFont(layout.getFont(TextType.FOOTER)).makeLabel(layout.getFooterPosition(), FOOTER));
    }

    private Font[] createNodeLabelFonts() {
        Font baseFont = this.layout.getFont(TextType.NODE_LABEL);
        double baseFontSize = baseFont.getSize2D();
        double pageSize = this.layout.getLeftLine().getLength();
        int nodesOnLeft = this.dataModel.getLeftNodes().size();
        int nodesOnRight = this.dataModel.getRightNodes().size();
        double leftFontSize = Math.min(pageSize / (double)nodesOnLeft - 30.0 / Math.pow(nodesOnLeft, 2.0), baseFontSize);
        double rightFontSize = Math.min(pageSize / (double)nodesOnRight - 30.0 / Math.pow(nodesOnRight, 2.0), baseFontSize);
        return new Font[]{baseFont.deriveFont((float)leftFontSize), baseFont.deriveFont((float)rightFontSize)};
    }

    private Paintable makeSortingLegend(NodeType leftType, NodeType rightType) {
        return new ComplexLabelPainter.Builder(this.layout.getSortLegendPosition(), this.layout.getFont(TextType.LEGEND), Color.black).withLineSpacing(1.2).addLine("Legend", this.layout.getFont(TextType.TITLE)).addLine("Sorted by").addLine("Left side:", Color.gray).addLine(leftType.getShortIdentifier(), Color.gray).addLine("Right side:", Color.gray).addLine(rightType.getShortIdentifier(), Color.gray).build();
    }

    private String getTimeStamp() {
        return new SimpleDateFormat("MMMMMMMMMMMMMMMMM d, yyyy | h:mm aa zzz").format(new Date());
    }

    private static Font findBasicFont(int size) {
        ImmutableList fontFamiliesToTry = ImmutableList.of((Object)"Arial", (Object)"Helvetica", (Object)"FreeSans", (Object)"Nimbus Sans");
        Font thisFont = new Font("Dialog", 0, 12);
        for (String family : fontFamiliesToTry) {
            thisFont = new Font(family, 0, size);
            if (!thisFont.getFamily().equals("Dialog")) break;
        }
        return thisFont;
    }

    private double calculateMaxNodeRadius() {
        int maxNodesOnOneSide = Math.max(this.dataModel.getLeftNodes().size(), this.dataModel.getRightNodes().size());
        return Math.min((double)this.layout.getMaxNodeRadius(), this.layout.getLeftLine().getLength() / ((double)(maxNodesOnOneSide * 2) * 0.5));
    }

    private Scale<Double, Double> makeNodeCodingAndLegend() {
        if (this.dataModel.hasWeightedNodes()) {
            ZeroAnchoredCircleRadiusScale nodeScale = new ZeroAnchoredCircleRadiusScale(this.calculateMaxNodeRadius());
            nodeScale.train(Iterables.transform(this.dataModel.getLeftNodes(), Node.WEIGHT_GETTER));
            nodeScale.train(Iterables.transform(this.dataModel.getRightNodes(), Node.WEIGHT_GETTER));
            nodeScale.doneTraining();
            this.painter.add(this.makeNodeLegend(nodeScale));
            return nodeScale;
        }
        return new ConstantValue<Double, Double>(this.calculateMaxNodeRadius());
    }

    private Scale<Double, Double> makeEdgeCodingAndLegend() {
        if (this.dataModel.hasWeightedEdges()) {
            BasicZeroAnchoredScale thicknessScale = new BasicZeroAnchoredScale(this.layout.getMinEdgeThickness(), this.layout.getMaxEdgeThickness());
            thicknessScale.train(Iterables.transform(this.dataModel.getEdges(), Edge.WEIGHT_GETTER));
            thicknessScale.doneTraining();
            this.painter.add(this.makeEdgeLegend(thicknessScale));
            return thicknessScale;
        }
        return new ConstantValue<Double, Double>(1.0);
    }

    private Paintable makeNodeLegend(Scale<Double, Double> coding) {
        ArrayList labels = Lists.newArrayList(coding.getExtrema());
        double halfway = ((Double)labels.get(0) + (Double)labels.get(1)) / 2.0;
        labels.add(1, halfway);
        CircleRadiusLegend legend = new CircleRadiusLegend(this.layout.getCircleLegendPosition(), (ImmutableList<String>)ImmutableList.of((Object)" ", (Object)CIRCLE_LEGEND_TITLE, (Object)this.dataModel.getNodeValueAttribute()), coding, (ImmutableList<Double>)ImmutableList.copyOf((Collection)labels), this.layout.getFont(TextType.TITLE), this.layout.getFont(TextType.LEGEND));
        return legend;
    }

    private Paintable makeEdgeLegend(Scale<Double, Double> edgeCoding) {
        ArrayList labels = Lists.newArrayList(edgeCoding.getExtrema());
        double halfway = ((Double)labels.get(0) + (Double)labels.get(1)) / 2.0;
        labels.add(1, halfway);
        EdgeWeightLegend legend = new EdgeWeightLegend(this.layout.getEdgeLegendPosition(), (ImmutableList<String>)ImmutableList.of((Object)" ", (Object)EDGE_LEGEND_TITLE, (Object)this.dataModel.getEdgeValueAttribute()), edgeCoding, (ImmutableList<Double>)ImmutableList.copyOf((Collection)labels), this.layout.getFont(TextType.TITLE), this.layout.getFont(TextType.LEGEND));
        return legend;
    }

    @Override
    public void paint(Graphics2D g) {
        this.painter.paint(g);
    }

    static /* synthetic */ ImmutableMap access$0() {
        return PRINT_FONTS;
    }

    static /* synthetic */ ImmutableMap access$1() {
        return WEB_FONTS;
    }

    public static enum Layout {
        PRINT(792, 612, new Point2D(18.0, 18.0), new LineSegment2D(296.0, 144.0, 296.0, 412.0), new LineSegment2D(496.0, 144.0, 496.0, 412.0), 14, 2.0, (ImmutableMap<TextType, Font>)PageDirector.access$0(), true),
        WEB(1280, 960, null, new LineSegment2D(480.0, 100.0, 480.0, 780.0), new LineSegment2D(800.0, 100.0, 800.0, 780.0), 24, 4.0, (ImmutableMap<TextType, Font>)PageDirector.access$1(), false);

        private final int width;
        private final int height;
        private final LineSegment2D leftLine;
        private final LineSegment2D rightLine;
        private final int maxNodeRadius;
        private final Point2D headerPosition;
        private final double maxEdgeThickness;
        private final boolean hasHowToRead;
        private final ImmutableMap<TextType, Font> fontScheme;

        private Layout(int width, int height, Point2D headerPosition, LineSegment2D leftLine, LineSegment2D rightLine, int maxNodeRadius, double maxEdgeThickness, ImmutableMap<TextType, Font> fontScheme, boolean hasHowToRead) {
            this.width = width;
            this.height = height;
            this.headerPosition = headerPosition;
            this.leftLine = leftLine;
            this.rightLine = rightLine;
            this.maxNodeRadius = maxNodeRadius;
            this.maxEdgeThickness = maxEdgeThickness;
            Preconditions.checkArgument((boolean)fontScheme.keySet().equals((Object)ImmutableSet.copyOf((Object[])TextType.values())));
            this.fontScheme = fontScheme;
            this.hasHowToRead = hasHowToRead;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        LineSegment2D getLeftLine() {
            return this.leftLine;
        }

        LineSegment2D getRightLine() {
            return this.rightLine;
        }

        Point2D getLeftTitlePosition() {
            return this.leftLine.getFirstPoint().translate((double)this.maxNodeRadius, -50.0);
        }

        Point2D getRightTitlePosition() {
            return this.rightLine.getFirstPoint().translate((double)(-this.maxNodeRadius), -50.0);
        }

        Point2D getHeaderPosition() {
            return this.headerPosition;
        }

        Point2D getFooterPosition() {
            Point2D thePoint = new Point2D((double)this.width / 2.0, (double)(this.height - 20));
            return thePoint;
        }

        public boolean hasTitle() {
            return this.headerPosition != null;
        }

        public int getMaxNodeRadius() {
            return this.maxNodeRadius;
        }

        public double getMaxEdgeThickness() {
            return this.maxEdgeThickness;
        }

        public Point2D getSortLegendPosition() {
            return (Point2D)this.getLegendPositions(4).get(0);
        }

        public Point2D getCircleLegendPosition() {
            return (Point2D)this.getLegendPositions(4).get(1);
        }

        public Point2D getEdgeLegendPosition() {
            return (Point2D)this.getLegendPositions(4).get(2);
        }

        public Point2D getHowToReadLegendPosition() {
            return (Point2D)this.getLegendPositions(4).get(3);
        }

        public ImmutableList<Point2D> getLegendPositions(int numLegends) {
            ArrayList points = Lists.newArrayList();
            double denominator = Math.max(1, numLegends - 1);
            LineSegment2D legendLine = new LineSegment2D(18.0, (double)(this.height - this.estimateLegendHeight()), (double)this.width / 2.0, (double)(this.height - this.estimateLegendHeight()));
            int i = 0;
            while (i < numLegends) {
                points.add(legendLine.getPoint((double)i / denominator));
                ++i;
            }
            return ImmutableList.copyOf((Collection)points);
        }

        private int estimateLegendHeight() {
            return 72 + this.getMaxNodeRadius() + 3 * this.getFont(TextType.TITLE).getSize();
        }

        public Font getFont(TextType type) {
            return (Font)this.fontScheme.get((Object)type);
        }

        public boolean hasHowToRead() {
            return this.hasHowToRead;
        }

        public double getMinEdgeThickness() {
            return this.getMaxEdgeThickness() / 10.0;
        }

        public EdgeShape getEdgeShape() {
            return new BezierEdgeShape(this.maxNodeRadius * 3);
        }
    }
}

