/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.bipartitenet.algorithm;

import com.google.common.annotations.VisibleForTesting;
import edu.iu.nwb.util.nwbfile.ParsingException;
import edu.iu.sci2.visualization.bipartitenet.LogStream;
import edu.iu.sci2.visualization.bipartitenet.PageDirector;
import edu.iu.sci2.visualization.bipartitenet.component.Paintable;
import edu.iu.sci2.visualization.bipartitenet.model.BipartiteGraphDataModel;
import edu.iu.sci2.visualization.bipartitenet.model.NWBDataImporter;
import edu.iu.sci2.visualization.bipartitenet.model.NodeType;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Properties;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.framework.data.BasicData;
import org.cishell.framework.data.Data;
import org.cishell.utilities.FileUtilities;
import org.freehep.graphicsio.ps.PSGraphics2D;
import org.freehep.util.UserProperties;

public class BipartiteNetAlgorithm
implements Algorithm {
    private final NWBDataImporter importer;
    private final File nwbFile;
    private final Data parentData;
    private final PageDirector.Layout layout;
    private final String subtitle;
    private final NodeType leftType;
    private final NodeType rightType;

    public BipartiteNetAlgorithm(Data parentData, File nwbFile, PageDirector.Layout layout, String subtitle, String edgeWeightColumn, NodeType leftType, NodeType rightType) {
        this.parentData = parentData;
        this.layout = layout;
        this.subtitle = subtitle;
        this.leftType = leftType;
        this.rightType = rightType;
        this.importer = NWBDataImporter.create("bipartitetype", leftType.getName(), leftType.getWeightColumn(), edgeWeightColumn, leftType.getOrdering(), rightType.getOrdering());
        this.nwbFile = nwbFile;
    }

    public Data[] execute() throws AlgorithmExecutionException {
        BufferedInputStream nwbStream = null;
        try {
            nwbStream = new BufferedInputStream(new FileInputStream(this.nwbFile));
            BipartiteGraphDataModel model = this.importer.constructModelFromFile(nwbStream);
            if (!model.hasAnyNodes()) {
                throw new AlgorithmExecutionException("Input graph has no nodes, can't make a meaningful graph.  Stopping.");
            }
            if (!this.layout.hasTitle() && !this.subtitle.isEmpty()) {
                LogStream.WARNING.send("A subtitle was requested, but it won't be rendered because the chosen layout does not render titles or subtitles.", new Object[0]);
            }
            PageDirector pageDirector = new PageDirector(this.layout, this.subtitle, model, this.leftType, this.rightType);
            Data psData = this.drawToPSFile(pageDirector);
            Data[] dataArray = new Data[]{psData};
            return dataArray;
        }
        catch (FileNotFoundException e) {
            throw new AlgorithmExecutionException("Internal error: data file disappeared?", (Throwable)e);
        }
        catch (IOException e) {
            throw new AlgorithmExecutionException((Throwable)e);
        }
        catch (ParsingException e) {
            throw new AlgorithmExecutionException(".nwb graph file parsing problem", (Throwable)e);
        }
        finally {
            if (nwbStream != null) {
                try {
                    nwbStream.close();
                }
                catch (IOException e) {
                    throw new AlgorithmExecutionException("Couldn't close NWB file", (Throwable)e);
                }
            }
        }
    }

    private Data drawToPSFile(Paintable paintable) throws IOException {
        File outFile = FileUtilities.createTemporaryFileInDefaultTemporaryDirectory((String)"BipartiteGraph", (String)"ps");
        UserProperties p = new UserProperties();
        p.setProperty(PSGraphics2D.EMBED_FONTS, false);
        p.setProperty(PSGraphics2D.TEXT_AS_SHAPES, false);
        PSGraphics2D g = new PSGraphics2D(outFile, new Dimension(this.layout.getWidth(), this.layout.getHeight()));
        g.setProperties((Properties)p);
        g.startExport();
        g.setClip(0, 0, this.layout.getWidth(), this.layout.getHeight());
        paintable.paint((Graphics2D)g);
        g.endExport();
        BasicData outData = new BasicData((Object)outFile, "file:text/ps");
        Dictionary metadata = outData.getMetadata();
        metadata.put("Label", "Bipartite Network Graph PS");
        metadata.put("Type", "Vector Image");
        metadata.put("Parent", this.parentData);
        return outData;
    }

    @VisibleForTesting
    PageDirector.Layout getLayout() {
        return this.layout;
    }
}

