/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.bipartitenet.algorithm;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import edu.iu.nwb.util.nwbfile.GetNWBFileMetadata;
import edu.iu.nwb.util.nwbfile.NWBFileParser;
import edu.iu.nwb.util.nwbfile.NWBFileParserHandler;
import edu.iu.nwb.util.nwbfile.NWBFileUtilities;
import edu.iu.nwb.util.nwbfile.ParsingException;
import edu.iu.sci2.visualization.bipartitenet.PageDirector;
import edu.iu.sci2.visualization.bipartitenet.algorithm.BipartiteNWBFileExaminer;
import edu.iu.sci2.visualization.bipartitenet.algorithm.BipartiteNetAlgorithm;
import edu.iu.sci2.visualization.bipartitenet.algorithm.CachedFunction;
import edu.iu.sci2.visualization.bipartitenet.algorithm.NodeOrderingOption;
import edu.iu.sci2.visualization.bipartitenet.model.NodeType;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.LinkedHashMap;
import java.util.Map;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmCreationFailedException;
import org.cishell.framework.algorithm.AlgorithmFactory;
import org.cishell.framework.algorithm.ParameterMutator;
import org.cishell.framework.data.Data;
import org.cishell.utilities.MutateParameterUtilities;
import org.cishell.utilities.mutateParameter.dropdown.DropdownMutator;
import org.osgi.service.metatype.ObjectClassDefinition;

public class BipartiteNetAlgorithmFactory
implements AlgorithmFactory,
ParameterMutator {
    public static final String NO_EDGE_WEIGHT_OPTION = "No edge weight";
    public static final String NO_NODE_WEIGHT_OPTION = "No node weight";
    private static final String LEFT_SIDE_TYPE_ID = "leftSideType";
    private static final String NODE_SIZE_COLUMN_ID = "nodeSizeColumn";
    private static final String EDGE_WEIGHT_COLUMN_ID = "edgeWeightColumn";
    private static final String LEFT_COLUMN_TITLE_ID = "leftColumnTitle";
    private static final String LEFT_COLUMN_ORDERING_ID = "leftColumnOrdering";
    private static final String RIGHT_COLUMN_TITLE_ID = "rightColumnTitle";
    private static final String RIGHT_COLUMN_ORDERING_ID = "rightColumnOrdering";
    private static final String IS_WEB_LAYOUT_ID = "is_web_layout";
    private static final String SUBTITLE_ID = "subtitle";
    private static final String DEFAULT_SUBTITLE_PREFIX = "Generated from ";
    private final CachedFunction<File, BipartiteNWBFileExaminer> examinerMaker = new CachedFunction<File, BipartiteNWBFileExaminer>(){

        public BipartiteNWBFileExaminer apply(File nwbFile) {
            BipartiteNWBFileExaminer it = new BipartiteNWBFileExaminer();
            try {
                new NWBFileParser(nwbFile).parse((NWBFileParserHandler)it);
            }
            catch (ParsingException e) {
                throw new AlgorithmCreationFailedException((Throwable)e);
            }
            catch (IOException e) {
                throw new AlgorithmCreationFailedException((Throwable)e);
            }
            return it;
        }
    };

    public Algorithm createAlgorithm(Data[] data, Dictionary<String, Object> parameters, CIShellContext ciShellContext) {
        BipartiteNWBFileExaminer exam = this.examinerMaker.getAndInvalidate(this.getNWBFile(data));
        ArrayList<String> types = new ArrayList<String>(exam.getBipartiteTypes());
        String leftSideType = (String)parameters.get(LEFT_SIDE_TYPE_ID);
        types.remove(leftSideType);
        String rightSideType = (String)Iterables.getOnlyElement(types);
        String edgeWeightColumn = (String)parameters.get(EDGE_WEIGHT_COLUMN_ID);
        if (NO_EDGE_WEIGHT_OPTION.equals(edgeWeightColumn)) {
            edgeWeightColumn = null;
        }
        PageDirector.Layout layout = (Boolean)parameters.get(IS_WEB_LAYOUT_ID) != false ? PageDirector.Layout.valueOf("WEB") : PageDirector.Layout.valueOf("PRINT");
        String subtitle = (String)parameters.get(SUBTITLE_ID);
        NodeType leftType = this.configureNodeType(parameters, leftSideType, LEFT_COLUMN_TITLE_ID, LEFT_COLUMN_ORDERING_ID, NODE_SIZE_COLUMN_ID);
        NodeType rightType = this.configureNodeType(parameters, rightSideType, RIGHT_COLUMN_TITLE_ID, RIGHT_COLUMN_ORDERING_ID, NODE_SIZE_COLUMN_ID);
        return new BipartiteNetAlgorithm(data[0], this.getNWBFile(data), layout, subtitle, edgeWeightColumn, leftType, rightType);
    }

    private NodeType configureNodeType(Dictionary<String, Object> params, String typeValue, String titleKey, String orderingKey, String weightKey) {
        String title = (String)params.get(titleKey);
        NodeOrderingOption ordering = NodeOrderingOption.getOption((String)params.get(orderingKey));
        String weightColumn = (String)params.get(weightKey);
        if (NO_NODE_WEIGHT_OPTION.equals(weightColumn)) {
            weightColumn = null;
        }
        if (title.trim().isEmpty()) {
            return NodeType.createWithDefaultDisplayName(typeValue, ordering, weightColumn);
        }
        return NodeType.create(typeValue, title, ordering, weightColumn);
    }

    public ObjectClassDefinition mutateParameters(Data[] data, ObjectClassDefinition oldParameters) {
        BipartiteNWBFileExaminer examiner = this.examinerMaker.applyAndCache(this.getNWBFile(data));
        LinkedHashMap nodeSchema = examiner.getNodeSchema();
        ArrayList nodeNumericColumns = Lists.newArrayList((Iterable)NWBFileUtilities.findNumericAttributes((Map)NWBFileUtilities.removeRequiredNodeProps((Map)nodeSchema)));
        nodeNumericColumns.add(0, NO_NODE_WEIGHT_OPTION);
        ArrayList edgeNumericColumns = Lists.newArrayList((Iterable)NWBFileUtilities.findNumericAttributes((Map)NWBFileUtilities.removeRequiredEdgeProps((Map)NWBFileUtilities.getConsistentEdgeAttributes((GetNWBFileMetadata)examiner))));
        edgeNumericColumns.add(0, NO_EDGE_WEIGHT_OPTION);
        DropdownMutator mutator = new DropdownMutator();
        mutator.add(LEFT_SIDE_TYPE_ID, examiner.getBipartiteTypes());
        mutator.add(NODE_SIZE_COLUMN_ID, (Collection)nodeNumericColumns);
        mutator.add(EDGE_WEIGHT_COLUMN_ID, (Collection)edgeNumericColumns);
        mutator.add(LEFT_COLUMN_ORDERING_ID, NodeOrderingOption.getIdentifiers());
        mutator.add(RIGHT_COLUMN_ORDERING_ID, NodeOrderingOption.getIdentifiers());
        ObjectClassDefinition newParameters = mutator.mutate(oldParameters);
        String defaultSubtitle = DEFAULT_SUBTITLE_PREFIX + data[0].getMetadata().get("Label");
        return MutateParameterUtilities.mutateDefaultValue((ObjectClassDefinition)newParameters, (String)SUBTITLE_ID, (String)defaultSubtitle);
    }

    private File getNWBFile(Data[] data) {
        return (File)data[0].getData();
    }
}

