/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.bipartitenet.algorithm;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;

public abstract class CachedFunction<I, O>
implements Function<I, O> {
    private I currentKey;
    private O currentValue;

    private void invalidate() {
        this.currentKey = null;
    }

    private boolean isValid() {
        return this.currentKey != null;
    }

    private boolean isCached(I key) {
        Preconditions.checkNotNull(key);
        return this.isValid() && key.equals(this.currentKey);
    }

    public O applyAndCache(I input) {
        Preconditions.checkNotNull(input);
        this.currentKey = input;
        this.currentValue = this.apply(input);
        return this.currentValue;
    }

    public O getAndInvalidate(I input) {
        Preconditions.checkNotNull(input);
        Object output = null;
        output = this.isCached(input) ? (Object)this.currentValue : this.apply(input);
        this.invalidate();
        return (O)output;
    }
}

