/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.bipartitenet.algorithm;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import edu.iu.sci2.visualization.bipartitenet.model.Node;
import java.util.Collection;

public enum NodeOrderingOption {
    LABEL_ASC("Label, ascending", "Alphabetical", Node.LABEL_ORDERING),
    LABEL_DESC("Label, descending", "Alphabetical", (Ordering<Node>)Node.LABEL_ORDERING.reverse()),
    LABEL_NUMERIC_ASC("Label, numeric, ascending", "Numeric", Node.NUMERIC_LABEL_ORDERING),
    LABEL_NUMERIC_DESC("Label, numeric, descending", "Numeric", (Ordering<Node>)Node.NUMERIC_LABEL_ORDERING.reverse()),
    WEIGHT_ASC("Weight, ascending", "Weight", Node.WEIGHT_ORDERING),
    WEIGHT_DESC("Weight, descending", "Weight", (Ordering<Node>)Node.WEIGHT_ORDERING.reverse());

    private final String identifier;
    private final Ordering<Node> ordering;
    private final String shortIdentifier;
    private static final ImmutableBiMap<String, Ordering<Node>> ORDERINGS;

    static {
        ORDERINGS = NodeOrderingOption.constructOrderings();
    }

    public String getShortIdentifier() {
        return this.shortIdentifier;
    }

    private NodeOrderingOption(String identifier, String shortIdentifier, Ordering<Node> ordering) {
        this.identifier = identifier;
        this.shortIdentifier = shortIdentifier;
        this.ordering = ordering;
    }

    private static ImmutableBiMap<String, Ordering<Node>> constructOrderings() {
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
        NodeOrderingOption[] nodeOrderingOptionArray = NodeOrderingOption.values();
        int n = nodeOrderingOptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            NodeOrderingOption entry = nodeOrderingOptionArray[n2];
            builder.put((Object)entry.getIdentifier(), entry.getOrdering());
            ++n2;
        }
        return builder.build();
    }

    public static ImmutableList<String> getIdentifiers() {
        return ImmutableList.copyOf((Collection)ORDERINGS.keySet());
    }

    public static Ordering<Node> getOrdering(String identifier) {
        Preconditions.checkArgument((boolean)ORDERINGS.containsKey((Object)identifier));
        return (Ordering)ORDERINGS.get((Object)identifier);
    }

    public static NodeOrderingOption getOption(String identifier) {
        NodeOrderingOption[] nodeOrderingOptionArray = NodeOrderingOption.values();
        int n = nodeOrderingOptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            NodeOrderingOption o = nodeOrderingOptionArray[n2];
            if (identifier.equals(o.getIdentifier())) {
                return o;
            }
            ++n2;
        }
        throw new IllegalArgumentException("Identifier " + identifier + " does not match any NodeOrderingOption");
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public Ordering<Node> getOrdering() {
        return this.ordering;
    }
}

