/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.bipartitenet.component;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import edu.iu.sci2.visualization.bipartitenet.component.ComplexLabelPainter;
import edu.iu.sci2.visualization.bipartitenet.component.Paintable;
import edu.iu.sci2.visualization.bipartitenet.component.SimpleLabelPainter;
import edu.iu.sci2.visualization.bipartitenet.scale.Scale;
import edu.iu.sci2.visualization.geomaps.utility.numberformat.NumberFormatFactory;
import edu.iu.sci2.visualization.geomaps.utility.numberformat.UnsignedZeroFormat;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import math.geom2d.Point2D;
import math.geom2d.conic.Circle2D;
import math.geom2d.line.LineSegment2D;
import math.geom2d.line.StraightLine2D;
import org.apache.commons.lang.ArrayUtils;

public class CircleRadiusLegend
implements Paintable {
    private final Scale<Double, Double> coding;
    private final ImmutableList<Double> labeledValues;
    private final Point2D topLeft;
    private final ComplexLabelPainter titlePainter;
    private static final int LABEL_X_OFFSET = 5;
    private final Font labelFont;

    public CircleRadiusLegend(Point2D topLeft, ImmutableList<String> headerLines, Scale<Double, Double> coding, ImmutableList<Double> labeledValues, Font titleFont, Font labelFont) {
        this.topLeft = topLeft;
        this.coding = coding;
        this.labeledValues = labeledValues;
        this.labelFont = labelFont;
        this.titlePainter = new ComplexLabelPainter.Builder(topLeft, labelFont, Color.black).withLineSpacing(1.2).addLine((String)headerLines.get(0), titleFont).addLine((String)headerLines.get(1)).addLine((String)headerLines.get(2), labelFont, Color.gray).build();
    }

    @Override
    public void paint(Graphics2D g) {
        this.titlePainter.paint(g);
        float yOffset = this.titlePainter.estimateHeight() + 8.0f;
        g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        LineSegment2D maxDiameter = this.paintCircles(g, yOffset);
        this.paintDataLabels(g, maxDiameter, yOffset);
    }

    private LineSegment2D paintCircles(Graphics2D g, float yOffset) {
        double maxActualRadius = (Double)this.coding.apply((Double)Ordering.natural().max(this.labeledValues));
        Point2D circleTopCenter = this.topLeft.translate(maxActualRadius, (double)yOffset);
        Point2D circleBottomCenter = circleTopCenter.translate(0.0, 2.0 * maxActualRadius);
        for (Double value : this.labeledValues) {
            double radius = (Double)this.coding.apply(value);
            Point2D circleCenter = circleBottomCenter.translate(0.0, -radius);
            new Circle2D(circleCenter, radius).draw(g);
        }
        return new LineSegment2D(circleTopCenter, circleBottomCenter);
    }

    private void paintDataLabels(Graphics2D g, LineSegment2D maxDiameter, float yOffset) {
        Point2D labelsTop = this.topLeft.translate(5.0 + maxDiameter.getLength(), (double)yOffset);
        StraightLine2D labelLine = maxDiameter.getParallel(labelsTop);
        ImmutableList reversedValues = this.labeledValues.reverse();
        int numLabels = reversedValues.size();
        double denominator = Math.max(1, numLabels - 1);
        UnsignedZeroFormat formatter = NumberFormatFactory.getNumberFormat((NumberFormatFactory.NumericFormatType)NumberFormatFactory.NumericFormatType.GENERAL, (double[])ArrayUtils.toPrimitive((Double[])((Double[])this.labeledValues.toArray((Object[])new Double[0]))));
        SimpleLabelPainter labelPainter = SimpleLabelPainter.alignedBy(SimpleLabelPainter.XAlignment.LEFT, SimpleLabelPainter.YAlignment.STRIKE_HEIGHT).withFont(this.labelFont).build();
        int i = 0;
        while (i < numLabels) {
            Point2D labelPoint = labelLine.getPoint((double)i / denominator);
            labelPainter.paintLabel(labelPoint, formatter.format(((Double)reversedValues.get(i)).doubleValue()), g);
            ++i;
        }
    }
}

