/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.bipartitenet.component;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import edu.iu.sci2.visualization.bipartitenet.component.Paintable;
import edu.iu.sci2.visualization.bipartitenet.component.SimpleLabelPainter;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.util.List;
import math.geom2d.Point2D;

public class ComplexLabelPainter
implements Paintable {
    private final Point2D position;
    private final List<String> lines;
    private final List<Font> fonts;
    private final List<Color> colors;
    private final double lineSpacing;

    private ComplexLabelPainter(Point2D position, double lineSpacing, List<String> lines, List<Font> fonts, List<Color> colors) {
        this.position = position;
        this.lineSpacing = lineSpacing;
        this.lines = lines;
        this.fonts = fonts;
        this.colors = colors;
    }

    public float estimateHeight() {
        float sum = 0.0f;
        for (Font f : this.fonts) {
            sum = (float)((double)sum + (double)f.getSize2D() * this.lineSpacing);
        }
        return sum;
    }

    @Override
    public void paint(Graphics2D g) {
        Point2D currentPosition = this.position;
        int i = 0;
        while (i < this.lines.size()) {
            Font thisFont = this.fonts.get(i);
            Graphics2D newGraphics = (Graphics2D)g.create();
            SimpleLabelPainter p = SimpleLabelPainter.alignedBy(SimpleLabelPainter.XAlignment.LEFT, SimpleLabelPainter.YAlignment.ASCENT).withFont(thisFont).withColor(this.colors.get(i)).build();
            p.paintLabel(currentPosition, this.lines.get(i), newGraphics);
            newGraphics.dispose();
            currentPosition = currentPosition.translate(0.0, (double)thisFont.getSize2D() * this.lineSpacing);
            ++i;
        }
    }

    /* synthetic */ ComplexLabelPainter(Point2D point2D, double d, List list, List list2, List list3, ComplexLabelPainter complexLabelPainter) {
        this(point2D, d, list, list2, list3);
    }

    public static class Builder {
        private final Point2D position;
        private final Font defaultFont;
        private final Color defaultColor;
        private final List<String> lines = Lists.newArrayList();
        private final List<Font> fonts = Lists.newArrayList();
        private final List<Color> colors = Lists.newArrayList();
        private double lineSpacing = 1.0;

        public Builder(Point2D topLeft, Font defaultFont, Color defaultColor) {
            Preconditions.checkNotNull((Object)topLeft);
            Preconditions.checkNotNull((Object)defaultFont);
            Preconditions.checkNotNull((Object)defaultColor);
            this.position = topLeft;
            this.defaultFont = defaultFont;
            this.defaultColor = defaultColor;
        }

        public Builder addLine(String line) {
            Preconditions.checkNotNull((Object)line);
            this.lines.add(line);
            this.fonts.add(this.defaultFont);
            this.colors.add(this.defaultColor);
            return this;
        }

        public Builder addLine(String line, Font font) {
            Preconditions.checkNotNull((Object)line);
            Preconditions.checkNotNull((Object)font);
            this.lines.add(line);
            this.fonts.add(font);
            this.colors.add(this.defaultColor);
            return this;
        }

        public Builder addLine(String line, Color color) {
            Preconditions.checkNotNull((Object)line);
            Preconditions.checkNotNull((Object)color);
            this.lines.add(line);
            this.fonts.add(this.defaultFont);
            this.colors.add(color);
            return this;
        }

        public Builder addLine(String line, Font font, Color color) {
            Preconditions.checkNotNull((Object)line);
            Preconditions.checkNotNull((Object)font);
            Preconditions.checkNotNull((Object)color);
            this.lines.add(line);
            this.fonts.add(font);
            this.colors.add(color);
            return this;
        }

        public Builder withLineSpacing(double lineSpacing) {
            this.lineSpacing = lineSpacing;
            return this;
        }

        public ComplexLabelPainter build() {
            return new ComplexLabelPainter(this.position, this.lineSpacing, this.lines, this.fonts, this.colors, null);
        }
    }
}

