/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.bipartitenet.component;

import edu.iu.sci2.visualization.bipartitenet.component.Paintable;
import java.awt.Graphics2D;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextLayout;
import java.awt.geom.Point2D;
import java.text.AttributedCharacterIterator;
import math.geom2d.Point2D;

public class MultiLineLabelPainter
implements Paintable {
    private Point2D initialPosition;
    private float wrappingWidth;
    private AttributedCharacterIterator styledText;

    public MultiLineLabelPainter(Point2D initialPosition, AttributedCharacterIterator styledText, float wrappingWidth) {
        this.initialPosition = initialPosition;
        this.styledText = styledText;
        this.wrappingWidth = wrappingWidth;
    }

    @Override
    public void paint(Graphics2D g) {
        TextLayout layout;
        Point2D.Float pen = this.initialPosition.getAsFloat();
        LineBreakMeasurer measurer = new LineBreakMeasurer(this.styledText, g.getFontRenderContext());
        while ((layout = measurer.nextLayout(this.wrappingWidth)) != null) {
            float dx = 0.0f;
            if (!layout.isLeftToRight()) {
                dx = this.wrappingWidth - layout.getAdvance();
            }
            layout.draw(g, pen.x + dx, pen.y + layout.getAscent());
            pen.y += layout.getAscent() + layout.getDescent();
        }
    }
}

