/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.bipartitenet.component;

import edu.iu.sci2.visualization.bipartitenet.component.Paintable;
import edu.iu.sci2.visualization.bipartitenet.model.Node;
import edu.iu.sci2.visualization.bipartitenet.scale.Scale;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import math.geom2d.Point2D;
import math.geom2d.conic.Circle2D;

public class NodeView
implements Paintable {
    public static final int NODE_TEXT_PADDING = 8;
    private final Node node;
    private final Point2D nodeCenter;
    private final Scale<Double, Double> coding;
    private final double maxHeight;
    private final Font nodeFont;
    private final double nodeToPageEdgeDistance;

    public NodeView(Node node, Point2D nodeCenter, Scale<Double, Double> coding, double maxHeight, Font nodeFont, double nodeToPageEdgeDistance) {
        this.node = node;
        this.nodeCenter = nodeCenter;
        this.coding = coding;
        this.maxHeight = maxHeight;
        this.nodeFont = nodeFont;
        this.nodeToPageEdgeDistance = nodeToPageEdgeDistance;
    }

    public int getCenterToTextDistance() {
        return Math.round(0.5f + (float)this.maxHeight + 8.0f);
    }

    private Node getNode() {
        return this.node;
    }

    public Point2D getNodeCenter() {
        return this.nodeCenter;
    }

    public double getRadius() {
        return (Double)this.coding.apply((Double)Node.WEIGHT_GETTER.apply((Object)this.node));
    }

    @Override
    public void paint(Graphics2D g) {
        g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        Circle2D circle = this.getNodeCircle();
        this.node.getDestination().paintLabel(this, g, this.nodeFont, this.nodeToPageEdgeDistance);
        g.setColor(this.node.getDestination().getFillColor());
        circle.fill(g);
        g.setColor(Color.black);
        circle.draw(g);
    }

    public Circle2D getNodeCircle() {
        Circle2D circle = new Circle2D(this.nodeCenter, this.getRadius());
        return circle;
    }

    public String getLabel() {
        return this.getNode().getLabel();
    }
}

