/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.bipartitenet.component;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import edu.iu.sci2.visualization.bipartitenet.component.Paintable;
import edu.iu.sci2.visualization.bipartitenet.component.Truncator;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.LineMetrics;
import java.awt.font.TextLayout;
import math.geom2d.Point2D;

public class SimpleLabelPainter {
    private final XAlignment xAlign;
    private final YAlignment yAlign;
    private final Font font;
    private final Color color;
    private final Truncator trunc;

    private SimpleLabelPainter(XAlignment xAlign, YAlignment yAlign, Font font, Color color, Truncator trunc) {
        Preconditions.checkNotNull((Object)((Object)xAlign));
        Preconditions.checkNotNull((Object)((Object)yAlign));
        Preconditions.checkNotNull((Object)trunc);
        this.xAlign = xAlign;
        this.yAlign = yAlign;
        this.font = font;
        this.color = color;
        this.trunc = trunc;
    }

    public Paintable getPaintable(final Point2D position, final String text) {
        return new Paintable(){

            @Override
            public void paint(Graphics2D g) {
                SimpleLabelPainter.this.paintLabel(position, text, g);
            }
        };
    }

    public void paintLabel(Point2D position, String text, Graphics2D g) {
        this.setFontIfNeeded(g);
        this.setColorIfNeeded(g);
        Font theFont = g.getFont();
        String truncated = this.trunc.truncate(text, g);
        TextLayout tl = new TextLayout(truncated, theFont, g.getFontRenderContext());
        double xPos = position.getX() + this.xAlign.apply(tl);
        LineMetrics lm = theFont.getLineMetrics("Asdfj", g.getFontRenderContext());
        double yPos = position.getY() + this.yAlign.apply(lm);
        g.drawString(truncated, (float)xPos, (float)yPos);
    }

    private void setColorIfNeeded(Graphics2D g) {
        if (this.color != null) {
            g.setColor(this.color);
        }
    }

    private void setFontIfNeeded(Graphics2D g) {
        if (this.font != null) {
            g.setFont(this.font);
        }
    }

    public static Builder alignedBy(XAlignment xAlign, YAlignment yAlign) {
        return new Builder(xAlign, yAlign);
    }

    /* synthetic */ SimpleLabelPainter(XAlignment xAlignment, YAlignment yAlignment, Font font, Color color, Truncator truncator, SimpleLabelPainter simpleLabelPainter) {
        this(xAlignment, yAlignment, font, color, truncator);
    }

    public static class Builder {
        private final XAlignment xAlign;
        private final YAlignment yAlign;
        private Font font;
        private Color color;
        private Truncator trunc = Truncator.none();

        public Builder(XAlignment xAlign, YAlignment yAlign) {
            this.xAlign = xAlign;
            this.yAlign = yAlign;
        }

        public Builder withFont(Font f) {
            this.font = f;
            return this;
        }

        public Builder withColor(Color c) {
            this.color = c;
            return this;
        }

        public Builder truncatedTo(double width) {
            this.trunc = Truncator.atWidth(width);
            return this;
        }

        public SimpleLabelPainter build() {
            return new SimpleLabelPainter(this.xAlign, this.yAlign, this.font, this.color, this.trunc, null);
        }

        public Paintable makeLabel(Point2D position, String text) {
            return this.build().getPaintable(position, text);
        }
    }

    public static enum XAlignment implements Function<TextLayout, Double>
    {
        LEFT{

            @Override
            public Double apply(TextLayout tl) {
                return 0.0;
            }
        }
        ,
        RIGHT{

            @Override
            public Double apply(TextLayout tl) {
                return -tl.getBounds().getWidth();
            }
        }
        ,
        CENTER{

            @Override
            public Double apply(TextLayout tl) {
                return -(tl.getBounds().getWidth() / 2.0);
            }
        };


        public abstract Double apply(TextLayout var1);
    }

    public static enum YAlignment implements Function<LineMetrics, Double>
    {
        BASELINE{

            @Override
            public Double apply(LineMetrics lm) {
                return 0.0;
            }
        }
        ,
        STRIKE_HEIGHT{

            @Override
            public Double apply(LineMetrics lm) {
                return -lm.getStrikethroughOffset();
            }
        }
        ,
        ASCENT{

            @Override
            public Double apply(LineMetrics lm) {
                return lm.getAscent();
            }
        }
        ,
        DESCENT{

            @Override
            public Double apply(LineMetrics lm) {
                return -lm.getDescent();
            }
        };


        public abstract Double apply(LineMetrics var1);
    }
}

