/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.bipartitenet.component;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;

public abstract class Truncator {
    public abstract String truncate(String var1, Graphics2D var2);

    public static Truncator none() {
        return new Truncator(){

            @Override
            public String truncate(String string, Graphics2D g) {
                return string;
            }
        };
    }

    public static Truncator atWidth(final double width) {
        return new Truncator(){

            @Override
            public String truncate(String string, Graphics2D g) {
                return Truncator.shortenIfNeeded(string, g, width);
            }
        };
    }

    private static String shortenIfNeeded(String string, Graphics2D g2d, double limit) {
        Rectangle2D stringBounds = g2d.getFontMetrics().getStringBounds(string, g2d);
        if (stringBounds.getWidth() <= limit) {
            return string;
        }
        String truncatationIndicator = "...";
        Rectangle2D truncationIndicatorBounds = g2d.getFontMetrics().getStringBounds(truncatationIndicator, g2d);
        int charWidth = g2d.getFontMetrics().getMaxAdvance();
        if (truncationIndicatorBounds.getWidth() + (double)charWidth >= limit) {
            return truncatationIndicator;
        }
        int numberToRemove = (int)((stringBounds.getWidth() - limit) / (double)charWidth);
        if (numberToRemove >= string.length()) {
            return truncatationIndicator;
        }
        String truncatedString = String.valueOf(string.substring(0, string.length() - numberToRemove)) + truncatationIndicator;
        while (g2d.getFontMetrics().getStringBounds(truncatedString, g2d).getWidth() > limit && numberToRemove < string.length()) {
            truncatedString = String.valueOf(string.substring(0, string.length() - ++numberToRemove)) + truncatationIndicator;
        }
        return truncatedString;
    }
}

