/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.bipartitenet.component.edge;

import com.google.common.collect.ImmutableList;
import edu.iu.sci2.visualization.bipartitenet.component.ComplexLabelPainter;
import edu.iu.sci2.visualization.bipartitenet.component.Paintable;
import edu.iu.sci2.visualization.bipartitenet.component.SimpleLabelPainter;
import edu.iu.sci2.visualization.bipartitenet.component.edge.ThicknessCodedEdgeView;
import edu.iu.sci2.visualization.bipartitenet.scale.Scale;
import edu.iu.sci2.visualization.geomaps.utility.numberformat.NumberFormatFactory;
import edu.iu.sci2.visualization.geomaps.utility.numberformat.UnsignedZeroFormat;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import math.geom2d.Point2D;
import math.geom2d.curve.AbstractContinuousCurve2D;
import math.geom2d.line.LineSegment2D;
import org.apache.commons.lang.ArrayUtils;

public class EdgeWeightLegend
implements Paintable {
    private final Point2D topLeft;
    private final Scale<Double, Double> coding;
    private final ImmutableList<Double> labeledValues;
    private final ComplexLabelPainter titlePainter;
    private static final double EDGE_LENGTH = 40.0;
    private static final int LABEL_X_OFFSET = 10;
    private final Font labelFont;

    public EdgeWeightLegend(Point2D topLeft, ImmutableList<String> headers, Scale<Double, Double> coding, ImmutableList<Double> labeledValues, Font titleFont, Font labelFont) {
        this.topLeft = topLeft;
        this.coding = coding;
        this.labeledValues = labeledValues;
        this.labelFont = labelFont;
        this.titlePainter = new ComplexLabelPainter.Builder(topLeft, labelFont, Color.black).withLineSpacing(1.2).addLine((String)headers.get(0), titleFont).addLine((String)headers.get(1)).addLine((String)headers.get(2), labelFont, Color.gray).build();
    }

    @Override
    public void paint(Graphics2D g) {
        this.titlePainter.paint(g);
        float yOffset = this.titlePainter.estimateHeight() + 8.0f;
        this.paintEdges(g, yOffset);
    }

    private void paintEdges(Graphics2D gForLabels, float yOffset) {
        Point2D edgesTopLeft;
        Graphics2D g = (Graphics2D)gForLabels.create();
        Point2D edgeStart = edgesTopLeft = this.topLeft.translate(0.0, (double)yOffset);
        UnsignedZeroFormat formatter = NumberFormatFactory.getNumberFormat((NumberFormatFactory.NumericFormatType)NumberFormatFactory.NumericFormatType.GENERAL, (double[])ArrayUtils.toPrimitive((Double[])((Double[])this.labeledValues.toArray((Object[])new Double[0]))));
        SimpleLabelPainter labelPainter = SimpleLabelPainter.alignedBy(SimpleLabelPainter.XAlignment.LEFT, SimpleLabelPainter.YAlignment.STRIKE_HEIGHT).withFont(this.labelFont).build();
        for (Double value : this.labeledValues.reverse()) {
            Point2D edgeEnd = edgeStart.translate(40.0, 0.0);
            LineSegment2D line = new LineSegment2D(edgeStart, edgeEnd);
            float lineThickness = ((Double)this.coding.apply(value)).floatValue();
            ThicknessCodedEdgeView.drawEdge((AbstractContinuousCurve2D)line, lineThickness, g);
            Point2D labelPoint = edgeEnd.translate(10.0, 0.0);
            labelPainter.paintLabel(labelPoint, formatter.format(value.doubleValue()), gForLabels);
            edgeStart = edgeStart.translate(0.0, 1.2 * (double)this.labelFont.getSize());
        }
        g.dispose();
    }
}

