/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.bipartitenet.component.edge;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import edu.iu.sci2.visualization.bipartitenet.component.NodeView;
import edu.iu.sci2.visualization.bipartitenet.component.Paintable;
import edu.iu.sci2.visualization.bipartitenet.component.edge.shape.EdgeShape;
import edu.iu.sci2.visualization.bipartitenet.model.Edge;
import edu.iu.sci2.visualization.bipartitenet.scale.Scale;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.util.Collection;
import math.geom2d.Point2D;
import math.geom2d.conic.Circle2D;
import math.geom2d.curve.AbstractContinuousCurve2D;
import math.geom2d.line.AbstractLine2D;
import math.geom2d.line.LinearShape2D;
import math.geom2d.line.StraightLine2D;
import math.geom2d.polygon.SimplePolygon2D;

public class ThicknessCodedEdgeView
implements Paintable {
    private final NodeView dest;
    private final NodeView src;
    private final Scale<Double, Double> edgeCoding;
    private final Edge e;
    private final EdgeShape edgeShape;

    public ThicknessCodedEdgeView(Edge e, NodeView src, NodeView dest, Scale<Double, Double> edgeCoding, EdgeShape edgeShape) {
        Preconditions.checkNotNull((Object)e);
        Preconditions.checkNotNull((Object)src);
        Preconditions.checkNotNull((Object)dest);
        Preconditions.checkNotNull(edgeCoding);
        Preconditions.checkNotNull((Object)edgeShape);
        this.e = e;
        this.src = src;
        this.dest = dest;
        this.edgeCoding = edgeCoding;
        this.edgeShape = edgeShape;
    }

    @Override
    public void paint(Graphics2D g) {
        Double edgeThickness = (Double)this.edgeCoding.apply(this.e.getWeight());
        AbstractContinuousCurve2D curve = this.edgeShape.connectNodes(this.src, this.dest);
        ThicknessCodedEdgeView.drawEdge(curve, edgeThickness.floatValue(), g);
    }

    public static void drawEdge(AbstractContinuousCurve2D curve, float edgeThickness, Graphics2D g) {
        ThicknessCodedEdgeView.drawLine(curve, edgeThickness, g);
    }

    public static void drawLine(AbstractContinuousCurve2D curve, float edgeThickness, Graphics2D g) {
        g.setStroke(new BasicStroke(edgeThickness, 0, 0));
        curve.draw(g);
    }

    public static void drawArrow(AbstractLine2D grossLine, float edgeThickness, Graphics2D g) {
        double endOffset = ThicknessCodedEdgeView.getArrowHeadLength(edgeThickness);
        double tStart = 0.0;
        double tEnd = 1.0 - endOffset / grossLine.getLength();
        AbstractLine2D fineLine = grossLine.getSubCurve(tStart, tEnd);
        ThicknessCodedEdgeView.drawLine((AbstractContinuousCurve2D)fineLine, edgeThickness, g);
        ThicknessCodedEdgeView.drawArrowHead(fineLine, edgeThickness, g);
    }

    public static void drawArrowHead(AbstractLine2D line, double edgeThickness, Graphics2D g) {
        Point2D end = line.getLastPoint();
        Point2D tip = line.getSupportingLine().getPoint(1.0 + ThicknessCodedEdgeView.getArrowHeadLength(edgeThickness) / line.getLength());
        Point2D arrowHookProjection = line.getPoint(1.0 - edgeThickness / line.getLength());
        StraightLine2D perp = line.getPerpendicular(arrowHookProjection);
        Circle2D arrowWidth = new Circle2D(arrowHookProjection, 1.5 * edgeThickness);
        ImmutableList backPoints = ImmutableList.copyOf((Collection)arrowWidth.getIntersections((LinearShape2D)perp));
        SimplePolygon2D arrowHead = new SimplePolygon2D(new Point2D[]{(Point2D)backPoints.get(0), tip, (Point2D)backPoints.get(1), end});
        arrowHead.fill(g);
    }

    private static double getArrowHeadLength(double edgeThickness) {
        return 2.0 * edgeThickness;
    }
}

