/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.bipartitenet.component.edge.shape;

import com.google.common.annotations.VisibleForTesting;
import edu.iu.sci2.visualization.bipartitenet.component.NodeView;
import edu.iu.sci2.visualization.bipartitenet.component.edge.shape.EdgeShape;
import edu.iu.sci2.visualization.bipartitenet.component.edge.shape.GeomUtils;
import math.geom2d.Point2D;
import math.geom2d.conic.Circle2D;
import math.geom2d.curve.AbstractContinuousCurve2D;
import math.geom2d.line.LineSegment2D;
import math.geom2d.spline.CubicBezierCurve2D;

public class BezierEdgeShape
implements EdgeShape {
    private static final int DEFAULT_CONTROL_POINT_OFFSET = 40;
    private final double controlPointOffset;

    public BezierEdgeShape() {
        this(40.0);
    }

    public BezierEdgeShape(double controlPointOffset) {
        this.controlPointOffset = controlPointOffset;
    }

    @Override
    public AbstractContinuousCurve2D connectNodes(NodeView source, NodeView dest) {
        Circle2D sourceCircle = GeomUtils.getNodeCircle(source);
        Circle2D destCircle = GeomUtils.getNodeCircle(dest);
        LineSegment2D sourceAndFirstControl = BezierEdgeShape.getSourceAndControl(sourceCircle, destCircle.getCenter(), this.controlPointOffset);
        LineSegment2D secondControlAndDest = BezierEdgeShape.getSourceAndControl(destCircle, sourceCircle.getCenter(), this.controlPointOffset);
        return new CubicBezierCurve2D(sourceAndFirstControl.getFirstPoint(), sourceAndFirstControl.getLastPoint(), secondControlAndDest.getLastPoint(), secondControlAndDest.getFirstPoint());
    }

    @VisibleForTesting
    static LineSegment2D getSourceAndControl(Circle2D nodeCircle, Point2D otherNodeCenter, double controlPointOffset) {
        Point2D firstPoint = nodeCircle.getCenter();
        Point2D controlPoint = GeomUtils.getNearestPointOnHorizontalDiameter(new Circle2D(nodeCircle.getCenter(), controlPointOffset), otherNodeCenter);
        return new LineSegment2D(firstPoint, controlPoint);
    }
}

