/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.bipartitenet.component.edge.shape;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import edu.iu.sci2.visualization.bipartitenet.component.NodeView;
import java.util.Collection;
import math.geom2d.Point2D;
import math.geom2d.conic.Circle2D;
import math.geom2d.line.LineSegment2D;
import math.geom2d.line.LinearShape2D;
import math.geom2d.line.StraightLine2D;

class GeomUtils {
    static final StraightLine2D HORIZONTAL = StraightLine2D.create((Point2D)Point2D.create((double)0.0, (double)0.0), (Point2D)Point2D.create((double)1.0, (double)0.0));

    GeomUtils() {
    }

    static LineSegment2D getHorizontalDiameter(Circle2D circle) {
        StraightLine2D lineThroughCenter = HORIZONTAL.getParallel(circle.getCenter());
        ImmutableList edgePoints = ImmutableList.copyOf((Collection)circle.getIntersections((LinearShape2D)lineThroughCenter));
        if (edgePoints.size() != 2) {
            throw new AssertionError((Object)"Line through the center of a circle should intersect the circle twice!");
        }
        return new LineSegment2D((Point2D)edgePoints.get(0), (Point2D)edgePoints.get(1));
    }

    static Circle2D getNodeCircle(NodeView nodeView) {
        return nodeView.getNodeCircle();
    }

    static Point2D getClosestPoint(LineSegment2D segment, Point2D target) {
        double t = segment.project(target);
        return segment.getPoint(t);
    }

    static Point2D getNearestPointOnHorizontalDiameter(Circle2D circle, Point2D nearPoint) {
        LineSegment2D horizontalDiameter = GeomUtils.getHorizontalDiameter(circle);
        return GeomUtils.getClosestPoint(horizontalDiameter, nearPoint);
    }

    static LineSegment2D clipEndsFromLineSegment(LineSegment2D baseLine, double startClip, double endClip) {
        Preconditions.checkArgument((startClip >= 0.0 ? 1 : 0) != 0, (Object)"startClip must be nonnegative");
        Preconditions.checkArgument((endClip >= 0.0 ? 1 : 0) != 0, (Object)"endClip must be nonnegative");
        double newLineLength = baseLine.getLength() - startClip - endClip;
        Preconditions.checkArgument((newLineLength > 0.0 ? 1 : 0) != 0, (String)"New line segment must have positive length (instead, length = %s)", (Object[])new Object[]{newLineLength});
        Circle2D startCircle = new Circle2D(baseLine.getFirstPoint(), startClip);
        Circle2D endCircle = new Circle2D(baseLine.getLastPoint(), endClip);
        Point2D newStart = (Point2D)Iterables.getOnlyElement((Iterable)startCircle.getIntersections((LinearShape2D)baseLine));
        Point2D newEnd = (Point2D)Iterables.getOnlyElement((Iterable)endCircle.getIntersections((LinearShape2D)baseLine));
        return new LineSegment2D(newStart, newEnd);
    }
}

