/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.bipartitenet.model;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import edu.iu.sci2.visualization.bipartitenet.model.Edge;
import edu.iu.sci2.visualization.bipartitenet.model.Node;
import java.util.Collection;

public class BipartiteGraphDataModel {
    private final ImmutableList<Node> leftNodes;
    private final ImmutableList<Node> rightNodes;
    private final ImmutableList<Edge> edges;
    private final String nodeValueAttribute;
    private final String edgeValueAttribute;

    public BipartiteGraphDataModel(ImmutableList<Node> leftNodes, ImmutableList<Node> rightNodes, Collection<Edge> edges, String nodeValueAttribute, String edgeValueAttribute) {
        this.edges = ImmutableList.copyOf(edges);
        this.nodeValueAttribute = nodeValueAttribute;
        this.edgeValueAttribute = edgeValueAttribute;
        this.leftNodes = leftNodes;
        this.rightNodes = rightNodes;
    }

    public ImmutableList<Node> getLeftNodes() {
        return this.leftNodes;
    }

    public ImmutableList<Node> getRightNodes() {
        return this.rightNodes;
    }

    public ImmutableList<Edge> getEdges() {
        return this.edges;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("left", this.leftNodes).add("right", this.rightNodes).add("edges", this.edges).add("nodeValueAttribute", (Object)this.nodeValueAttribute).add("edgeValueAttribute", (Object)this.edgeValueAttribute).toString();
    }

    public String getNodeValueAttribute() {
        return this.nodeValueAttribute;
    }

    public String getEdgeValueAttribute() {
        return this.edgeValueAttribute;
    }

    public boolean hasWeightedNodes() {
        return this.nodeValueAttribute != null;
    }

    public boolean hasWeightedEdges() {
        return this.edgeValueAttribute != null;
    }

    public boolean hasAnyNodes() {
        return !this.leftNodes.isEmpty() || !this.rightNodes.isEmpty();
    }
}

