/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.bipartitenet.model;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import edu.iu.sci2.visualization.bipartitenet.model.Node;

public class Edge {
    public static final Function<Edge, Double> WEIGHT_GETTER = new Function<Edge, Double>(){

        public Double apply(Edge it) {
            return it.getWeight();
        }
    };
    private final Node leftNode;
    private final Node rightNode;
    private final double weight;

    public Edge(Node leftNode, Node rightNode, double weight) {
        Preconditions.checkNotNull((Object)leftNode);
        Preconditions.checkNotNull((Object)rightNode);
        this.leftNode = leftNode;
        this.rightNode = rightNode;
        this.weight = weight;
    }

    public Node getLeftNode() {
        return this.leftNode;
    }

    public Node getRightNode() {
        return this.rightNode;
    }

    public double getWeight() {
        return this.weight;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).addValue((Object)this.leftNode.getLabel()).addValue((Object)this.rightNode.getLabel()).add("weight", this.weight).toString();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.leftNode == null ? 0 : this.leftNode.hashCode());
        result = 31 * result + (this.rightNode == null ? 0 : this.rightNode.hashCode());
        long temp = Double.doubleToLongBits(this.weight);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Edge other = (Edge)obj;
        if (this.leftNode == null ? other.leftNode != null : !this.leftNode.equals(other.leftNode)) {
            return false;
        }
        if (this.rightNode == null ? other.rightNode != null : !this.rightNode.equals(other.rightNode)) {
            return false;
        }
        return Double.doubleToLongBits(this.weight) == Double.doubleToLongBits(other.weight);
    }
}

