/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.bipartitenet.model;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import edu.iu.sci2.visualization.bipartitenet.LogStream;
import edu.iu.sci2.visualization.bipartitenet.model.Edge;
import edu.iu.sci2.visualization.bipartitenet.model.Node;
import edu.iu.sci2.visualization.bipartitenet.model.NodeDestination;
import edu.iu.sci2.visualization.bipartitenet.model.NodeProvider;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.cishell.utilities.NumberUtilities;

public class EdgeHandler {
    private final String edgeWeightColumn;
    private final NodeProvider nodeProvider;
    private final List<Edge> edges = Lists.newArrayList();

    public EdgeHandler(String edgeWeightColumn, NodeProvider nodeProvider) {
        this.edgeWeightColumn = edgeWeightColumn;
        this.nodeProvider = nodeProvider;
    }

    public void setDirectedEdgeSchema(LinkedHashMap<String, String> schema) {
        this.checkEdgeSchema(schema);
    }

    public void setUndirectedEdgeSchema(LinkedHashMap<String, String> schema) {
        this.checkEdgeSchema(schema);
    }

    private void checkEdgeSchema(LinkedHashMap<String, String> schema) {
        Preconditions.checkArgument((this.edgeWeightColumn == null || schema.containsKey(this.edgeWeightColumn) ? 1 : 0) != 0);
    }

    public void addDirectedEdge(int sourceNode, int targetNode, Map<String, Object> attributes) {
        this.addUndirectedEdge(sourceNode, targetNode, attributes);
    }

    public void addUndirectedEdge(int node1, int node2, Map<String, Object> attributes) {
        double weight;
        Node right;
        Node left;
        Node something = this.nodeProvider.getNodeById(node1);
        if (something.getDestination() == NodeDestination.LEFT) {
            left = something;
            right = this.nodeProvider.getNodeById(node2);
        } else {
            left = this.nodeProvider.getNodeById(node2);
            right = something;
        }
        if (left.getDestination() == right.getDestination()) {
            LogStream.WARNING.send("Graph is not properly bipartite: %s and %s are linked but are on the same side!", left, right);
        }
        if (this.edgeWeightColumn != null) {
            weight = NumberUtilities.interpretObjectAsDouble((Object)attributes.get(this.edgeWeightColumn));
            if (weight < 0.0) {
                LogStream.WARNING.send("Edge between %s and %s has negative weight (%d), which is not handled well by this algorithm's display code.", left, right, weight);
            }
        } else {
            weight = 1.0;
        }
        this.edges.add(new Edge(left, right, weight));
    }

    public ImmutableList<Edge> getEdges() {
        return ImmutableList.copyOf(this.edges);
    }

    public String getWeightColumn() {
        return this.edgeWeightColumn;
    }
}

