/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.bipartitenet.model;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import edu.iu.nwb.util.nwbfile.NWBFileParser;
import edu.iu.nwb.util.nwbfile.NWBFileParserAdapter;
import edu.iu.nwb.util.nwbfile.NWBFileParserHandler;
import edu.iu.nwb.util.nwbfile.ParsingException;
import edu.iu.sci2.visualization.bipartitenet.LogStream;
import edu.iu.sci2.visualization.bipartitenet.model.BipartiteGraphDataModel;
import edu.iu.sci2.visualization.bipartitenet.model.Edge;
import edu.iu.sci2.visualization.bipartitenet.model.EdgeHandler;
import edu.iu.sci2.visualization.bipartitenet.model.Node;
import edu.iu.sci2.visualization.bipartitenet.model.NodeHandler;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class NWBDataImporter {
    private final NodeHandler nodeHandler;
    private final EdgeHandler edgeHandler;
    private boolean hasBeenUsed = false;

    public static NWBDataImporter create(String nodeTypeCol, String typeForLeftSide, String nodeWeightCol, String edgeWeightCol, Ordering<Node> leftNodeOrdering, Ordering<Node> rightNodeOrdering) {
        NodeHandler nodeHandler = new NodeHandler(nodeTypeCol, nodeWeightCol, typeForLeftSide, leftNodeOrdering, rightNodeOrdering);
        EdgeHandler edgeHandler = new EdgeHandler(edgeWeightCol, nodeHandler);
        return new NWBDataImporter(nodeHandler, edgeHandler);
    }

    NWBDataImporter(NodeHandler nodeHandler, EdgeHandler edgeHandler) {
        this.nodeHandler = nodeHandler;
        this.edgeHandler = edgeHandler;
    }

    public BipartiteGraphDataModel constructModelFromFile(InputStream nwbData) throws IOException, ParsingException {
        Preconditions.checkState((!this.hasBeenUsed ? 1 : 0) != 0);
        ParserHandler handler = new ParserHandler();
        NWBFileParser parser = new NWBFileParser(nwbData);
        parser.parse((NWBFileParserHandler)handler);
        this.hasBeenUsed = true;
        return handler.constructGraphDataModel();
    }

    private class ParserHandler
    extends NWBFileParserAdapter {
        private ParserHandler() {
        }

        public void setNodeSchema(LinkedHashMap<String, String> schema) {
            NWBDataImporter.this.nodeHandler.setNodeSchema(schema);
        }

        public void addNode(int id, String label, Map<String, Object> attributes) {
            NWBDataImporter.this.nodeHandler.addNode(id, label, attributes);
        }

        public void addDirectedEdge(int sourceNode, int targetNode, Map<String, Object> attributes) {
            NWBDataImporter.this.edgeHandler.addDirectedEdge(sourceNode, targetNode, attributes);
        }

        public void addUndirectedEdge(int node1, int node2, Map<String, Object> attributes) {
            NWBDataImporter.this.edgeHandler.addUndirectedEdge(node1, node2, attributes);
        }

        public void setDirectedEdgeSchema(LinkedHashMap<String, String> schema) {
            NWBDataImporter.this.edgeHandler.setDirectedEdgeSchema(schema);
        }

        public void setUndirectedEdgeSchema(LinkedHashMap<String, String> schema) {
            NWBDataImporter.this.edgeHandler.setUndirectedEdgeSchema(schema);
        }

        public BipartiteGraphDataModel constructGraphDataModel() {
            ImmutableList<Node> leftNodes = NWBDataImporter.this.nodeHandler.getLeftNodes();
            ImmutableList<Node> rightNodes = NWBDataImporter.this.nodeHandler.getRightNodes();
            if (leftNodes.isEmpty()) {
                LogStream.WARNING.send("Supposedly bipartite graph has no left-hand nodes", new Object[0]);
            }
            if (rightNodes.isEmpty()) {
                LogStream.WARNING.send("Supposedly bipartite graph has no right-hand nodes", new Object[0]);
            }
            return new BipartiteGraphDataModel(leftNodes, rightNodes, (Collection<Edge>)NWBDataImporter.this.edgeHandler.getEdges(), NWBDataImporter.this.nodeHandler.getWeightColumn(), NWBDataImporter.this.edgeHandler.getWeightColumn());
        }
    }
}

