/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.bipartitenet.model;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Ordering;
import edu.iu.sci2.visualization.bipartitenet.model.NodeDestination;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Node {
    public static final Function<Node, Double> WEIGHT_GETTER = new Function<Node, Double>(){

        public Double apply(Node it) {
            return it.getWeight();
        }
    };
    public static final Function<Node, String> LABEL_GETTER = new Function<Node, String>(){

        public String apply(Node it) {
            return it.getLabel();
        }
    };
    static final Function<String, Double> EXTRACT_DOUBLE_VALUE = new Function<String, Double>(){
        private final Pattern FLOATING_POINT_NUMBER = Pattern.compile("[-+]?[0-9]*\\.?[0-9]+([eE][-+]?[0-9]+)?");

        public Double apply(String label) {
            Matcher m = this.FLOATING_POINT_NUMBER.matcher(label);
            if (!m.find()) {
                return null;
            }
            try {
                return Double.valueOf(m.group(0));
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
    };
    public static final Ordering<Node> WEIGHT_ORDERING = Ordering.natural().onResultOf(WEIGHT_GETTER);
    public static final Ordering<Node> LABEL_ORDERING = Ordering.natural().onResultOf(LABEL_GETTER);
    public static final Ordering<String> NUMERIC_STRING_ORDERING = Ordering.natural().nullsLast().onResultOf(EXTRACT_DOUBLE_VALUE).compound((Comparator)Ordering.natural());
    public static final Ordering<Node> NUMERIC_LABEL_ORDERING = NUMERIC_STRING_ORDERING.onResultOf(LABEL_GETTER);
    private final String label;
    private final double weight;
    private final NodeDestination destination;

    public Node(String label, double weight, NodeDestination destination) {
        Preconditions.checkNotNull((Object)label);
        Preconditions.checkNotNull((Object)((Object)destination));
        this.destination = destination;
        this.label = label;
        this.weight = weight;
    }

    public String getLabel() {
        return this.label;
    }

    public double getWeight() {
        return this.weight;
    }

    public NodeDestination getDestination() {
        return this.destination;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("label", (Object)this.label).add("weight", this.weight).add("side", (Object)this.destination).toString();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.destination == null ? 0 : this.destination.hashCode());
        result = 31 * result + (this.label == null ? 0 : this.label.hashCode());
        long temp = Double.doubleToLongBits(this.weight);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Node other = (Node)obj;
        if (this.destination != other.destination) {
            return false;
        }
        if (this.label == null ? other.label != null : !this.label.equals(other.label)) {
            return false;
        }
        return Double.doubleToLongBits(this.weight) == Double.doubleToLongBits(other.weight);
    }
}

