/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.bipartitenet.model;

import edu.iu.sci2.visualization.bipartitenet.component.NodeView;
import edu.iu.sci2.visualization.bipartitenet.component.SimpleLabelPainter;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import math.geom2d.Point2D;

public enum NodeDestination {
    LEFT(new Color(31, 120, 180), SimpleLabelPainter.XAlignment.RIGHT){

        @Override
        protected Point2D getAlignPoint(NodeView nv) {
            return nv.getNodeCenter().translate((double)(-nv.getCenterToTextDistance()), 0.0);
        }
    }
    ,
    RIGHT(new Color(178, 223, 138), SimpleLabelPainter.XAlignment.LEFT){

        @Override
        protected Point2D getAlignPoint(NodeView nv) {
            return nv.getNodeCenter().translate((double)nv.getCenterToTextDistance(), 0.0);
        }
    };

    private final Color fillColor;
    private final SimpleLabelPainter.XAlignment alignDirection;

    private NodeDestination(Color fillColor, SimpleLabelPainter.XAlignment alignDirection) {
        this.fillColor = fillColor;
        this.alignDirection = alignDirection;
    }

    protected abstract Point2D getAlignPoint(NodeView var1);

    public void paintLabel(NodeView nv, Graphics2D g, Font defaultFont, double nodeCenterToPageEdge) {
        SimpleLabelPainter painter = SimpleLabelPainter.alignedBy(this.alignDirection, SimpleLabelPainter.YAlignment.STRIKE_HEIGHT).withFont(defaultFont).truncatedTo(nodeCenterToPageEdge - (double)nv.getCenterToTextDistance() - 10.0).build();
        painter.paintLabel(this.getAlignPoint(nv), nv.getLabel(), g);
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    /* synthetic */ NodeDestination(String string, int n, Color color, SimpleLabelPainter.XAlignment xAlignment, NodeDestination nodeDestination) {
        this(color, xAlignment);
    }
}

