/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.bipartitenet.model;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import edu.iu.sci2.visualization.bipartitenet.LogStream;
import edu.iu.sci2.visualization.bipartitenet.model.Node;
import edu.iu.sci2.visualization.bipartitenet.model.NodeDestination;
import edu.iu.sci2.visualization.bipartitenet.model.NodeProvider;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.cishell.utilities.NumberUtilities;

public class NodeHandler
implements NodeProvider {
    private String nodeTypeCol;
    private String nodeWeightCol;
    private String typeForLeftSide;
    private final Map<Integer, Node> nodeById = Maps.newHashMap();
    private List<Node> leftNodes;
    private List<Node> rightNodes;
    private ImmutableMap<String, String> schema;
    private final Ordering<? super Node> leftSideSort;
    private final Ordering<? super Node> rightSideSort;

    public NodeHandler(String nodeTypeCol, String nodeWeightCol, String typeForLeftSide, Ordering<? super Node> leftSideSort, Ordering<? super Node> rightSideSort) {
        this.nodeTypeCol = nodeTypeCol;
        this.nodeWeightCol = nodeWeightCol;
        this.typeForLeftSide = typeForLeftSide;
        this.leftSideSort = leftSideSort;
        this.rightSideSort = rightSideSort;
        this.leftNodes = Lists.newArrayList();
        this.rightNodes = Lists.newArrayList();
    }

    public void addNode(int id, String label, Map<String, ? extends Object> attributes) {
        double weight = this.getNodeWeight(attributes);
        if (weight < 0.0) {
            LogStream.WARNING.send("Node '%s' has negative weight (%d), which is not handled well by this algorithm's display code.", label, weight);
        }
        String type = (String)attributes.get(this.nodeTypeCol);
        Node nodeObj = new Node(label, weight, this.getDestination(type));
        this.insert(id, nodeObj);
    }

    public double getNodeWeight(Map<String, ? extends Object> attributes) {
        if (this.nodeWeightCol != null) {
            return NumberUtilities.interpretObjectAsDouble((Object)attributes.get(this.nodeWeightCol));
        }
        return 1.0;
    }

    public void setNodeSchema(LinkedHashMap<String, String> schema) {
        Preconditions.checkArgument((this.nodeWeightCol == null || schema.containsKey(this.nodeWeightCol) ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)schema.containsKey(this.nodeTypeCol));
        this.schema = ImmutableMap.copyOf(schema);
    }

    private NodeDestination getDestination(String type) {
        if (this.typeForLeftSide.equalsIgnoreCase(type)) {
            return NodeDestination.LEFT;
        }
        return NodeDestination.RIGHT;
    }

    private void insert(int id, Node nodeObj) {
        this.nodeById.put(id, nodeObj);
        if (nodeObj.getDestination() == NodeDestination.LEFT) {
            this.leftNodes.add(nodeObj);
        } else {
            this.rightNodes.add(nodeObj);
        }
    }

    @Override
    public Node getNodeById(int id) {
        return this.nodeById.get(id);
    }

    public ImmutableList<Node> getLeftNodes() {
        return ImmutableList.copyOf((Collection)this.leftSideSort.sortedCopy(this.leftNodes));
    }

    public ImmutableList<Node> getRightNodes() {
        return ImmutableList.copyOf((Collection)this.rightSideSort.sortedCopy(this.rightNodes));
    }

    public ImmutableMap<String, String> getNodeSchema() {
        return this.schema;
    }

    public String getWeightColumn() {
        return this.nodeWeightCol;
    }
}

