/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.bipartitenet.model;

import com.google.common.collect.Ordering;
import edu.iu.sci2.visualization.bipartitenet.algorithm.NodeOrderingOption;
import edu.iu.sci2.visualization.bipartitenet.model.Node;

public class NodeType {
    private final String name;
    private final String displayName;
    private final NodeOrderingOption orderingOption;
    private final String weightColumn;

    public static NodeType create(String name, String displayName, NodeOrderingOption orderingOption, String weightColumn) {
        return new NodeType(name, displayName, orderingOption, weightColumn);
    }

    public static NodeType createWithDefaultDisplayName(String name, NodeOrderingOption orderingOption, String weightColumn) {
        return new NodeType(name, name, orderingOption, weightColumn);
    }

    private NodeType(String name, String displayName, NodeOrderingOption orderingOption, String weightColumn) {
        this.name = name;
        this.displayName = displayName;
        this.orderingOption = orderingOption;
        this.weightColumn = weightColumn;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Ordering<Node> getOrdering() {
        return this.orderingOption.getOrdering();
    }

    public String getOrderingIdentifier() {
        return this.orderingOption.getIdentifier();
    }

    public String getWeightColumn() {
        return this.weightColumn;
    }

    public String getShortIdentifier() {
        return this.orderingOption.getShortIdentifier();
    }
}

