/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.bipartitenet.scale;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import edu.iu.sci2.visualization.bipartitenet.scale.Range;
import edu.iu.sci2.visualization.bipartitenet.scale.Scale;

public class BasicZeroAnchoredScale
implements Scale<Double, Double> {
    private final double resultForZero;
    private final double resultForMax;
    private final double intercept;
    private final Range<Double> dataRange = Range.create();
    private double slope;
    private boolean doneTraining = false;

    public BasicZeroAnchoredScale(double resultForZero, double resultForMax) {
        this.resultForZero = resultForZero;
        this.resultForMax = resultForMax;
        this.intercept = resultForZero;
    }

    @Override
    public void train(Iterable<Double> trainingData) {
        Preconditions.checkState((!this.doneTraining ? 1 : 0) != 0, (Object)"Tried to add more training data after done training!");
        this.dataRange.considerAll(trainingData);
        this.slope = (this.resultForMax - this.resultForZero) / (this.dataRange.getMax() - 0.0);
    }

    @Override
    public void doneTraining() {
        this.doneTraining = true;
    }

    public Double apply(Double value) {
        return value * this.slope + this.intercept;
    }

    @Override
    public ImmutableList<Double> getExtrema() {
        return ImmutableList.of((Object)this.dataRange.getMin(), (Object)this.dataRange.getMax());
    }
}

