/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.bipartitenet.scale;

import com.google.common.collect.ImmutableList;
import edu.iu.sci2.visualization.bipartitenet.scale.BasicZeroAnchoredScale;
import edu.iu.sci2.visualization.bipartitenet.scale.Scale;
import java.awt.Color;

public class ColorIntensityScale
implements Scale<Double, Color> {
    private static final double MAXIMUM_INTENSITY = 1.0;
    private static final double MINIMUM_INTENSITY = 0.1;
    private static final float DEFAULT_HUE = 0.0f;
    private static final float DEFAULT_SATURATION = 0.0f;
    private final BasicZeroAnchoredScale intensityScale = new BasicZeroAnchoredScale(0.1, 1.0);
    private final float hue;
    private final float saturation;

    private ColorIntensityScale(float hue, float saturation) {
        this.hue = hue;
        this.saturation = saturation;
    }

    public static ColorIntensityScale createWithHS(float hue, float saturation) {
        return new ColorIntensityScale(hue, saturation);
    }

    public static ColorIntensityScale createWithDefaultColor() {
        return new ColorIntensityScale(0.0f, 0.0f);
    }

    public Color apply(Double value) {
        return Color.getHSBColor(this.hue, this.saturation, 1.0f - this.intensityScale.apply(value).floatValue());
    }

    @Override
    public void train(Iterable<Double> trainingData) {
        this.intensityScale.train(trainingData);
    }

    @Override
    public void doneTraining() {
        this.intensityScale.doneTraining();
    }

    @Override
    public ImmutableList<Double> getExtrema() {
        return this.intensityScale.getExtrema();
    }
}

