/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.bipartitenet.scale;

import com.google.common.base.Preconditions;
import com.google.common.collect.Ordering;

public class Range<T> {
    private final Ordering<? super T> ordering;
    private T min = null;
    private T max = null;

    private Range(Ordering<? super T> ordering) {
        this.ordering = ordering;
    }

    public static <T> Range<T> copyOf(Range<T> inRange) {
        Range<? super T> newRange = new Range<T>(inRange.ordering);
        newRange.min = inRange.min;
        newRange.max = inRange.max;
        return newRange;
    }

    public static <T extends Comparable<? super T>> Range<T> create() {
        return Range.createWithOrdering(Ordering.natural());
    }

    public static <T> Range<T> createWithOrdering(Ordering<T> ordering) {
        return new Range<T>(ordering);
    }

    public void consider(T item) {
        this.min = this.ordering.nullsLast().min(this.min, item);
        this.max = this.ordering.nullsFirst().max(this.max, item);
    }

    public void considerAll(Iterable<? extends T> items) {
        for (T item : items) {
            this.consider(item);
        }
    }

    public T getMin() {
        Preconditions.checkState((this.min != null ? 1 : 0) != 0, (Object)"Range is invalid because no non-null items have been submitted");
        return this.min;
    }

    public T getMax() {
        Preconditions.checkState((this.min != null ? 1 : 0) != 0, (Object)"Range is invalid because no non-null items have been submitted");
        return this.max;
    }
}

