/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.bipartitenet.scale;

import com.google.common.collect.ImmutableList;
import edu.iu.sci2.visualization.bipartitenet.scale.BasicZeroAnchoredScale;
import edu.iu.sci2.visualization.bipartitenet.scale.Scale;

public class ZeroAnchoredCircleRadiusScale
implements Scale<Double, Double> {
    private static final double MIN_RADIUS = 1.0;
    private final BasicZeroAnchoredScale areaScale;

    public ZeroAnchoredCircleRadiusScale(double maxRadius) {
        this.areaScale = new BasicZeroAnchoredScale(1.0, Math.PI * maxRadius * maxRadius);
    }

    @Override
    public void train(Iterable<Double> trainingData) {
        this.areaScale.train(trainingData);
    }

    @Override
    public void doneTraining() {
        this.areaScale.doneTraining();
    }

    public Double apply(Double value) {
        if (value < 0.0) {
            return 1.0;
        }
        return Math.sqrt(this.areaScale.apply(value) / Math.PI);
    }

    @Override
    public ImmutableList<Double> getExtrema() {
        return this.areaScale.getExtrema();
    }
}

