/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.geomaps;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Files;
import edu.iu.nwb.converter.prefusecsv.reader.PrefuseCsvReader;
import edu.iu.sci2.visualization.geomaps.GeoMapsCirclesFactory;
import edu.iu.sci2.visualization.geomaps.GeoMapsNetworkFactory;
import edu.iu.sci2.visualization.geomaps.GeoMapsRegionsFactory;
import edu.iu.sci2.visualization.geomaps.LogStream;
import edu.iu.sci2.visualization.geomaps.data.scaling.Scaling;
import edu.iu.sci2.visualization.geomaps.geo.projection.KnownProjectedCRSDescriptor;
import edu.iu.sci2.visualization.geomaps.geo.shapefiles.Shapefile;
import edu.iu.sci2.visualization.geomaps.viz.AnnotationMode;
import edu.iu.sci2.visualization.geomaps.viz.CircleDimension;
import edu.iu.sci2.visualization.geomaps.viz.FeatureDimension;
import edu.iu.sci2.visualization.geomaps.viz.PageLayout;
import edu.iu.sci2.visualization.geomaps.viz.legend.LegendCreationException;
import edu.iu.sci2.visualization.geomaps.viz.model.GeoMap;
import edu.iu.sci2.visualization.geomaps.viz.model.GeoMapException;
import edu.iu.sci2.visualization.geomaps.viz.ps.GeoMapViewPS;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import org.antlr.stringtemplate.StringTemplate;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.framework.algorithm.AlgorithmFactory;
import org.cishell.framework.data.BasicData;
import org.cishell.framework.data.Data;
import org.cishell.utilities.DataFactory;
import org.geotools.factory.FactoryRegistryException;
import org.opengis.referencing.operation.TransformException;
import prefuse.data.Table;

public class GeoMapsAlgorithm<G, D extends Enum<D>>
implements Algorithm {
    private static final String BASE_TITLE = "Geospatial Visualization";
    private static final String CSV_MIME_TYPE = "file:text/csv";
    static final String POSTSCRIPT_MIME_TYPE = "file:text/ps";
    static final String OUTPUT_FILE_EXTENSION = "ps";
    private final Data[] data;
    private final Dictionary<String, Object> parameters;
    private final PageLayout pageLayout;
    private final AnnotationMode<G, D> annotationMode;
    private final String subtitle;
    private final StringTemplate templateForHowToRead;
    private final String dataLabel;
    private static final String EXAMPLE_FILE_URL_STEM = "/edu/iu/sci2/visualization/geomaps/testing/";

    public GeoMapsAlgorithm(Data[] data, Dictionary<String, Object> parameters, PageLayout pageLayout, AnnotationMode<G, D> annotationMode, String dataLabel, String subtitle, StringTemplate templateForHowToRead) {
        this.data = data;
        this.parameters = parameters;
        this.pageLayout = pageLayout;
        this.annotationMode = annotationMode;
        this.dataLabel = dataLabel;
        this.subtitle = subtitle;
        this.templateForHowToRead = templateForHowToRead;
    }

    public Data[] execute() throws AlgorithmExecutionException {
        try {
            Data inDatum = this.data[0];
            Table inTable = (Table)inDatum.getData();
            String dataLabel = Strings.nullToEmpty((String)this.dataLabel);
            String fullTitle = String.format("%s (%s)", BASE_TITLE, this.subtitle);
            GeoMap geoMap = this.annotationMode.createGeoMap(inTable, this.parameters, this.pageLayout, fullTitle, this.subtitle, this.templateForHowToRead);
            GeoMapViewPS geoMapView = new GeoMapViewPS(geoMap, this.pageLayout);
            File geoMapFile = geoMapView.writeToPSFile(dataLabel, OUTPUT_FILE_EXTENSION);
            Data[] outData = new Data[]{DataFactory.forFile((File)geoMapFile, (String)POSTSCRIPT_MIME_TYPE, (String)"Vector Image", (Data)inDatum, (String)fullTitle)};
            return outData;
        }
        catch (IOException e) {
            throw new AlgorithmExecutionException("Error creating PostScript file: " + e.getMessage(), (Throwable)e);
        }
        catch (TransformException e) {
            throw new AlgorithmExecutionException("Error transforming features: " + e.getMessage(), (Throwable)e);
        }
        catch (LegendCreationException e) {
            throw new AlgorithmExecutionException("Error creating legend: " + e.getMessage(), (Throwable)e);
        }
        catch (GeoMapViewPS.ShapefilePostScriptWriterException e) {
            throw new AlgorithmExecutionException("Error visualizing geo map: " + e.getMessage(), (Throwable)e);
        }
        catch (FactoryRegistryException e) {
            throw new AlgorithmExecutionException("Geography error: " + e.getMessage(), (Throwable)e);
        }
        catch (GeoMapException e) {
            throw new AlgorithmExecutionException("Error creating geo map: " + e.getMessage(), (Throwable)e);
        }
    }

    public static void main(String[] args) {
        Example.WORLD_CIRCLES.run(PageLayout.PRINT, new KnownProjectedCRSDescriptor[0]);
        Example.US_REGIONS.run(PageLayout.PRINT, new KnownProjectedCRSDescriptor[0]);
        Example.DUPLICATE_REGIONS.run(PageLayout.PRINT, new KnownProjectedCRSDescriptor[0]);
        Example.DUPLICATE_CIRCLES.run(PageLayout.PRINT, new KnownProjectedCRSDescriptor[0]);
    }

    private static enum Example {
        WORLD_CIRCLES(Shapefile.WORLD, GeoMapsAlgorithm.class.getResource("/edu/iu/sci2/visualization/geomaps/testing/area-population-and-population-density-of-20-most-populous-cities.csv"), "20 most populous cities", (ImmutableMap<PageLayout, Class<? extends AlgorithmFactory>>)ImmutableMap.of((Object)((Object)PageLayout.PRINT), GeoMapsCirclesFactory.Print.class, (Object)((Object)PageLayout.WEB), GeoMapsCirclesFactory.Web.class), (ImmutableMap<String, Object>)ImmutableMap.builder().put((Object)GeoMapsNetworkFactory.Parameter.LATITUDE.id(), (Object)"Latitude").put((Object)GeoMapsNetworkFactory.Parameter.LONGITUDE.id(), (Object)"Longitude").put((Object)CircleDimension.AREA.getColumnNameParameterId(), (Object)"Population").put((Object)CircleDimension.AREA.getScalingParameterId(), (Object)Scaling.Linear.toString()).put((Object)CircleDimension.OUTER_COLOR.getColumnNameParameterId(), (Object)"Area (sq. km.)").put((Object)CircleDimension.OUTER_COLOR.getScalingParameterId(), (Object)Scaling.Logarithmic.toString()).put((Object)CircleDimension.OUTER_COLOR.getRangeParameterId(), (Object)"White to Black").put((Object)CircleDimension.INNER_COLOR.getColumnNameParameterId(), (Object)"Population density (people per sq. km.)").put((Object)CircleDimension.INNER_COLOR.getScalingParameterId(), (Object)Scaling.Linear.toString()).put((Object)CircleDimension.INNER_COLOR.getRangeParameterId(), (Object)"Yellow to Blue").build()),
        US_REGIONS(Shapefile.UNITED_STATES, GeoMapsAlgorithm.class.getResource("/edu/iu/sci2/visualization/geomaps/testing/us-state-populations.csv"), "U.S. state populations", (ImmutableMap<PageLayout, Class<? extends AlgorithmFactory>>)ImmutableMap.of((Object)((Object)PageLayout.PRINT), GeoMapsRegionsFactory.Print.class, (Object)((Object)PageLayout.WEB), GeoMapsRegionsFactory.Web.class), (ImmutableMap<String, Object>)ImmutableMap.builder().put((Object)"featureName", (Object)"State").put((Object)FeatureDimension.REGION_COLOR.getColumnNameParameterId(), (Object)"Population").put((Object)FeatureDimension.REGION_COLOR.getScalingParameterId(), (Object)Scaling.Linear.toString()).put((Object)FeatureDimension.REGION_COLOR.getRangeParameterId(), (Object)"Yellow to Blue").build()),
        ALASKA_CIRCLE_OVERLAY_INSET_TEST(Shapefile.UNITED_STATES, GeoMapsAlgorithm.class.getResource("/edu/iu/sci2/visualization/geomaps/testing/alaska-circle-overlay-inset-test.csv"), "Alaska circle overlay inset test", (ImmutableMap<PageLayout, Class<? extends AlgorithmFactory>>)ImmutableMap.of((Object)((Object)PageLayout.PRINT), GeoMapsCirclesFactory.Print.class, (Object)((Object)PageLayout.WEB), GeoMapsCirclesFactory.Web.class), (ImmutableMap<String, Object>)ImmutableMap.builder().put((Object)GeoMapsNetworkFactory.Parameter.LATITUDE.id(), (Object)"Latitude").put((Object)GeoMapsNetworkFactory.Parameter.LONGITUDE.id(), (Object)"Longitude").put((Object)CircleDimension.AREA.getColumnNameParameterId(), (Object)CircleDimension.AREA.getColumnNameParameterDisablingToken()).put((Object)CircleDimension.AREA.getScalingParameterId(), (Object)Scaling.Linear.toString()).put((Object)CircleDimension.OUTER_COLOR.getColumnNameParameterId(), (Object)CircleDimension.OUTER_COLOR.getColumnNameParameterDisablingToken()).put((Object)CircleDimension.OUTER_COLOR.getScalingParameterId(), (Object)Scaling.Logarithmic.toString()).put((Object)CircleDimension.OUTER_COLOR.getRangeParameterId(), (Object)"White to Black").put((Object)CircleDimension.INNER_COLOR.getColumnNameParameterId(), (Object)CircleDimension.INNER_COLOR.getColumnNameParameterDisablingToken()).put((Object)CircleDimension.INNER_COLOR.getScalingParameterId(), (Object)Scaling.Linear.toString()).put((Object)CircleDimension.INNER_COLOR.getRangeParameterId(), (Object)"Yellow to Blue").build()),
        CONGRESSIONAL_CIRCLES(Shapefile.UNITED_STATES, GeoMapsAlgorithm.class.getResource("/edu/iu/sci2/visualization/geomaps/testing/congressional-districts.csv"), "congressional districts", (ImmutableMap<PageLayout, Class<? extends AlgorithmFactory>>)ImmutableMap.of((Object)((Object)PageLayout.PRINT), GeoMapsCirclesFactory.Print.class, (Object)((Object)PageLayout.WEB), GeoMapsCirclesFactory.Web.class), (ImmutableMap<String, Object>)ImmutableMap.builder().put((Object)GeoMapsNetworkFactory.Parameter.LATITUDE.id(), (Object)"Latitude").put((Object)GeoMapsNetworkFactory.Parameter.LONGITUDE.id(), (Object)"Longitude").put((Object)CircleDimension.AREA.getColumnNameParameterId(), (Object)"Circle Size").put((Object)CircleDimension.AREA.getScalingParameterId(), (Object)Scaling.Linear.toString()).put((Object)CircleDimension.OUTER_COLOR.getColumnNameParameterId(), (Object)CircleDimension.OUTER_COLOR.getColumnNameParameterDisablingToken()).put((Object)CircleDimension.OUTER_COLOR.getScalingParameterId(), (Object)Scaling.Logarithmic.toString()).put((Object)CircleDimension.OUTER_COLOR.getRangeParameterId(), (Object)"White to Black").put((Object)CircleDimension.INNER_COLOR.getColumnNameParameterId(), (Object)"Circle Size").put((Object)CircleDimension.INNER_COLOR.getScalingParameterId(), (Object)Scaling.Linear.toString()).put((Object)CircleDimension.INNER_COLOR.getRangeParameterId(), (Object)"Yellow to Blue").build()),
        DUPLICATE_REGIONS(Shapefile.UNITED_STATES, GeoMapsAlgorithm.class.getResource("/edu/iu/sci2/visualization/geomaps/testing/duplicates.csv"), "duplicate regions", (ImmutableMap<PageLayout, Class<? extends AlgorithmFactory>>)ImmutableMap.of((Object)((Object)PageLayout.PRINT), GeoMapsRegionsFactory.Print.class, (Object)((Object)PageLayout.WEB), GeoMapsRegionsFactory.Web.class), (ImmutableMap<String, Object>)ImmutableMap.builder().put((Object)"featureName", (Object)"State").put((Object)FeatureDimension.REGION_COLOR.getColumnNameParameterId(), (Object)"Value").put((Object)FeatureDimension.REGION_COLOR.getScalingParameterId(), (Object)Scaling.Linear.toString()).put((Object)FeatureDimension.REGION_COLOR.getRangeParameterId(), (Object)"Yellow to Blue").build()),
        DUPLICATE_CIRCLES(Shapefile.UNITED_STATES, GeoMapsAlgorithm.class.getResource("/edu/iu/sci2/visualization/geomaps/testing/duplicates.csv"), "duplicate circles", (ImmutableMap<PageLayout, Class<? extends AlgorithmFactory>>)ImmutableMap.of((Object)((Object)PageLayout.PRINT), GeoMapsCirclesFactory.Print.class, (Object)((Object)PageLayout.WEB), GeoMapsCirclesFactory.Web.class), (ImmutableMap<String, Object>)ImmutableMap.builder().put((Object)GeoMapsNetworkFactory.Parameter.LATITUDE.id(), (Object)"Latitude").put((Object)GeoMapsNetworkFactory.Parameter.LONGITUDE.id(), (Object)"Longitude").put((Object)CircleDimension.AREA.getColumnNameParameterId(), (Object)"Value").put((Object)CircleDimension.AREA.getScalingParameterId(), (Object)Scaling.Linear.toString()).put((Object)CircleDimension.OUTER_COLOR.getColumnNameParameterId(), (Object)CircleDimension.OUTER_COLOR.getColumnNameParameterDisablingToken()).put((Object)CircleDimension.OUTER_COLOR.getScalingParameterId(), (Object)Scaling.Logarithmic.toString()).put((Object)CircleDimension.OUTER_COLOR.getRangeParameterId(), (Object)"White to Black").put((Object)CircleDimension.INNER_COLOR.getColumnNameParameterId(), (Object)CircleDimension.INNER_COLOR.getColumnNameParameterDisablingToken()).put((Object)CircleDimension.INNER_COLOR.getScalingParameterId(), (Object)Scaling.Linear.toString()).put((Object)CircleDimension.INNER_COLOR.getRangeParameterId(), (Object)"Yellow to Blue").build());

        private final Shapefile shapefile;
        private final URL csvFileURL;
        private final String dataLabel;
        private final ImmutableMap<PageLayout, Class<? extends AlgorithmFactory>> algorithmFactoryClassForPageLayout;
        private final ImmutableMap<String, Object> baseParameters;

        private Example(Shapefile shapefile, URL tableFileURL, String dataLabel, ImmutableMap<PageLayout, Class<? extends AlgorithmFactory>> algorithmFactoryClassForPageLayout, ImmutableMap<String, Object> baseParameters) {
            this.shapefile = shapefile;
            this.csvFileURL = tableFileURL;
            this.dataLabel = dataLabel;
            this.algorithmFactoryClassForPageLayout = algorithmFactoryClassForPageLayout;
            this.baseParameters = baseParameters;
        }

        private void run(String outputFilenamePrefix, PageLayout pageLayout, Dictionary<String, Object> parameters) {
            try {
                LogStream.DEBUG.send("parameters are " + parameters, new Object[0]);
                Algorithm algorithm = Example.createAlgorithm((Class)this.algorithmFactoryClassForPageLayout.get((Object)pageLayout), this.csvFileURL, this.dataLabel, parameters);
                LogStream.DEBUG.send("Executing.. ", new Object[0]);
                Data[] outData = algorithm.execute();
                File outFileWithRawName = (File)outData[0].getData();
                File outFile = File.createTempFile(outputFilenamePrefix, ".ps");
                Files.copy((File)outFileWithRawName, (File)outFile);
                LogStream.DEBUG.send(outFile.getAbsolutePath(), new Object[0]);
                LogStream.DEBUG.send(".. Done.", new Object[0]);
                Desktop.getDesktop().open(outFile);
            }
            catch (AlgorithmExecutionException e) {
                LogStream.ERROR.send(e);
            }
            catch (InstantiationException e) {
                LogStream.ERROR.send(e);
            }
            catch (IllegalAccessException e) {
                LogStream.ERROR.send(e);
            }
            catch (URISyntaxException e) {
                LogStream.ERROR.send(e);
            }
            catch (IOException e) {
                LogStream.ERROR.send(e);
            }
        }

        private void run(PageLayout pageLayout, KnownProjectedCRSDescriptor ... explicitProjections) {
            Dictionary<String, Object> parameters = Example.assembleParameters(this.shapefile, this.baseParameters);
            if (explicitProjections.length == 0) {
                this.run("geo-viz-", pageLayout, parameters);
            } else {
                KnownProjectedCRSDescriptor[] knownProjectedCRSDescriptorArray = explicitProjections;
                int n = explicitProjections.length;
                int n2 = 0;
                while (n2 < n) {
                    KnownProjectedCRSDescriptor projection = knownProjectedCRSDescriptorArray[n2];
                    Hashtable<String, Object> freshParameters = new Hashtable<String, Object>((Hashtable)parameters);
                    ((Dictionary)freshParameters).put("projection", projection.getNiceName());
                    this.run("geo-viz-" + projection.getNiceName() + "-", pageLayout, freshParameters);
                    ++n2;
                }
            }
        }

        private static Dictionary<String, Object> assembleParameters(Shapefile shapefile, ImmutableMap<String, Object> baseParameters) {
            Hashtable<String, Object> parameters = new Hashtable<String, Object>();
            ((Dictionary)parameters).put(GeoMapsNetworkFactory.Parameter.SHAPEFILE_KEY.id(), shapefile.getNiceName());
            for (Map.Entry entry : baseParameters.entrySet()) {
                ((Dictionary)parameters).put((String)entry.getKey(), entry.getValue());
            }
            return parameters;
        }

        private static Data[] convertToPrefuseTableData(URL csvFileURL) throws URISyntaxException, AlgorithmExecutionException {
            File inFile = new File(csvFileURL.toURI());
            BasicData data = new BasicData((Object)inFile, GeoMapsAlgorithm.CSV_MIME_TYPE);
            PrefuseCsvReader prefuseCSVReader = new PrefuseCsvReader(new Data[]{data});
            return prefuseCSVReader.execute();
        }

        private static Algorithm createAlgorithm(Class<? extends AlgorithmFactory> algorithmFactoryClass, URL csvFileURL, String dataLabel, Dictionary<String, Object> parameters) throws InstantiationException, IllegalAccessException, URISyntaxException, AlgorithmExecutionException {
            AlgorithmFactory algorithmFactory = algorithmFactoryClass.newInstance();
            Data[] prefuseTableData = Example.convertToPrefuseTableData(csvFileURL);
            prefuseTableData[0].getMetadata().put("Label", dataLabel);
            CIShellContext ciContext = new CIShellContext(){

                public Object getService(String service) {
                    throw new AssertionError((Object)"This mock CIShellContext provides no services.");
                }
            };
            return algorithmFactory.createAlgorithm(prefuseTableData, parameters, ciContext);
        }
    }
}

