/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.geomaps;

import com.google.common.collect.ImmutableList;
import com.vividsolutions.jts.geom.Coordinate;
import edu.iu.sci2.visualization.geomaps.GeoMapsAlgorithm;
import edu.iu.sci2.visualization.geomaps.GeoMapsNetworkFactory;
import edu.iu.sci2.visualization.geomaps.metatype.Parameters;
import edu.iu.sci2.visualization.geomaps.viz.CircleDimension;
import edu.iu.sci2.visualization.geomaps.viz.PageLayout;
import edu.iu.sci2.visualization.geomaps.viz.VizDimension;
import edu.iu.sci2.visualization.geomaps.viz.model.CircleAnnotationMode;
import edu.iu.sci2.visualization.geomaps.viz.ps.HowToRead;
import java.util.Collections;
import java.util.Dictionary;
import java.util.EnumSet;
import java.util.List;
import org.antlr.stringtemplate.StringTemplate;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmCreationFailedException;
import org.cishell.framework.algorithm.AlgorithmFactory;
import org.cishell.framework.algorithm.ParameterMutator;
import org.cishell.framework.data.Data;
import org.cishell.utilities.ColumnNotFoundException;
import org.cishell.utilities.TableUtilities;
import org.cishell.utilities.mutateParameter.dropdown.DropdownMutator;
import org.osgi.service.metatype.ObjectClassDefinition;
import prefuse.data.Table;

public abstract class GeoMapsCirclesFactory
implements AlgorithmFactory,
ParameterMutator {
    public static final String SUBTITLE = "Proportional Symbol Map";
    public static final StringTemplate TEMPLATE_FOR_HOW_TO_READ = HowToRead.TEMPLATE_GROUP.getInstanceOf("proportionalSymbols");

    public Algorithm createAlgorithm(Data[] data, Dictionary<String, Object> parameters, CIShellContext ciShellContext) {
        String latitudeColumnName = (String)parameters.get(GeoMapsNetworkFactory.Parameter.LATITUDE.id());
        String longitudeColumnName = (String)parameters.get(GeoMapsNetworkFactory.Parameter.LONGITUDE.id());
        String dataLabel = (String)parameters.get(GeoMapsNetworkFactory.Parameter.DATA_LABEL.id());
        return new GeoMapsAlgorithm<Coordinate, CircleDimension>(data, parameters, this.getPageLayout(), new CircleAnnotationMode(longitudeColumnName, latitudeColumnName), dataLabel, SUBTITLE, TEMPLATE_FOR_HOW_TO_READ);
    }

    abstract PageLayout getPageLayout();

    public ObjectClassDefinition mutateParameters(Data[] data, ObjectClassDefinition oldParameters) {
        Table table = (Table)data[0].getData();
        ImmutableList numericColumnNames = Collections.emptyList();
        try {
            numericColumnNames = ImmutableList.copyOf((Object[])TableUtilities.getValidNumberColumnNamesInTable((Table)table));
        }
        catch (ColumnNotFoundException e) {
            String string = "Table does not seem to have any purely numeric columns.  If your table does not have columns for the latitudes and longitudes of records, you may wish to use one of the geocoders under Analysis > Geospatial.";
            throw new AlgorithmCreationFailedException(string, (Throwable)e);
        }
        DropdownMutator mutator = new DropdownMutator();
        Parameters.addShapefileAndProjectionParameters(mutator);
        Parameters.addLatitudeParameter(mutator, (List<String>)numericColumnNames, GeoMapsNetworkFactory.Parameter.LATITUDE.id());
        Parameters.addLongitudeParameter(mutator, (List<String>)numericColumnNames, GeoMapsNetworkFactory.Parameter.LONGITUDE.id());
        for (VizDimension vizDimension : EnumSet.allOf(CircleDimension.class)) {
            vizDimension.addOptionsToAlgorithmParameters(mutator, (List<String>)numericColumnNames);
        }
        return GeoMapsNetworkFactory.mutateSubtitleDefaultValue(data, mutator.mutate(oldParameters));
    }

    public static class Print
    extends GeoMapsCirclesFactory {
        @Override
        PageLayout getPageLayout() {
            return PageLayout.PRINT;
        }
    }

    public static class Web
    extends GeoMapsCirclesFactory {
        @Override
        PageLayout getPageLayout() {
            return PageLayout.WEB;
        }
    }
}

