/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.geomaps;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.vividsolutions.jts.geom.Coordinate;
import edu.iu.nwb.util.nwbfile.NWBFileParser;
import edu.iu.nwb.util.nwbfile.NWBFileParserHandler;
import edu.iu.nwb.util.nwbfile.NWBFileUtilities;
import edu.iu.nwb.util.nwbfile.ParsingException;
import edu.iu.nwb.util.nwbfile.pipe.FieldMakerFunction;
import edu.iu.nwb.util.nwbfile.pipe.ParserPipe;
import edu.iu.sci2.visualization.geomaps.GeoMapsNetworkFactory;
import edu.iu.sci2.visualization.geomaps.LogStream;
import edu.iu.sci2.visualization.geomaps.geo.projection.KnownProjectedCRSDescriptor;
import edu.iu.sci2.visualization.geomaps.geo.shapefiles.Shapefile;
import edu.iu.sci2.visualization.geomaps.utility.NicelyNamedEnums;
import edu.iu.sci2.visualization.geomaps.viz.Circle;
import edu.iu.sci2.visualization.geomaps.viz.CircleDimension;
import edu.iu.sci2.visualization.geomaps.viz.FeatureView;
import edu.iu.sci2.visualization.geomaps.viz.PageLayout;
import edu.iu.sci2.visualization.geomaps.viz.legend.LabeledReference;
import edu.iu.sci2.visualization.geomaps.viz.model.GeoMap;
import edu.iu.sci2.visualization.geomaps.viz.model.GeoMapException;
import edu.iu.sci2.visualization.geomaps.viz.ps.GeoMapViewPS;
import edu.iu.sci2.visualization.geomaps.viz.ps.HowToRead;
import edu.iu.sci2.visualization.geomaps.viz.strategy.CircleAreaStrategy;
import edu.iu.sci2.visualization.geomaps.viz.strategy.NullColorStrategy;
import edu.iu.sci2.visualization.geomaps.viz.strategy.StrokeColorStrategy;
import java.awt.Desktop;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.EnumMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmCreationFailedException;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.framework.algorithm.AlgorithmFactory;
import org.cishell.framework.data.BasicData;
import org.cishell.framework.data.Data;
import org.cishell.utilities.DataFactory;
import org.cishell.utilities.NumberUtilities;
import org.geotools.factory.FactoryRegistryException;
import org.opengis.referencing.operation.TransformException;

public class GeoMapsNetworkAlgorithm
implements Algorithm {
    private static final int ANCHOR_CIRCLE_SIZE = 5;
    private static final String IS_ANCHOR_FIELD = "isAnchor";
    private static final String X_POS_FIELD = "x";
    private static final String Y_POS_FIELD = "y";
    private final Data[] data;
    private final String dataLabel;
    private final String latitudeAttrib;
    private final String longitudeAttrib;
    private final Shapefile shapefile;
    private final KnownProjectedCRSDescriptor projection;
    private static final String EXAMPLE_FILE_URL_STEM = "/edu/iu/sci2/visualization/geomaps/testing/";

    public GeoMapsNetworkAlgorithm(Data[] data, Dictionary<String, Object> parameters, String dataLabel) {
        this.data = data;
        this.latitudeAttrib = (String)parameters.get(GeoMapsNetworkFactory.Parameter.LATITUDE.id());
        this.longitudeAttrib = (String)parameters.get(GeoMapsNetworkFactory.Parameter.LONGITUDE.id());
        this.dataLabel = dataLabel;
        this.shapefile = NicelyNamedEnums.getConstantNamed(Shapefile.class, (String)parameters.get(GeoMapsNetworkFactory.Parameter.SHAPEFILE_KEY.id()));
        this.projection = this.shapefile.getDefaultProjectedCrs();
        if (this.latitudeAttrib.equals(this.longitudeAttrib)) {
            throw new AlgorithmCreationFailedException("Latitude and longitude attributes must be distinct.");
        }
    }

    static PageLayout getPageLayout() {
        return PageLayout.PRINT;
    }

    public Data[] execute() throws AlgorithmExecutionException {
        try {
            Data inDatum = this.data[0];
            File inFile = (File)inDatum.getData();
            ImmutableCollection<Shapefile.AnchorPoint> anchorPoints = this.shapefile.getAnchorPoints();
            List<Circle> anchorPointsAsCircles = GeoMapsNetworkAlgorithm.drawAnchorPoints(anchorPoints);
            GeoMap geoMap = new GeoMap("Geospatial Network", this.shapefile, this.projection, (Collection<FeatureView>)ImmutableSet.of(), anchorPointsAsCircles, (Collection<LabeledReference>)ImmutableSet.of(), GeoMapsNetworkAlgorithm.getPageLayout(), (Optional<HowToRead>)Optional.absent());
            GeoMapViewPS geoMapView = new GeoMapViewPS(geoMap, GeoMapsNetworkAlgorithm.getPageLayout());
            File outNetwork = this.processNetwork(inFile, (Collection<Shapefile.AnchorPoint>)anchorPoints, geoMapView);
            File geoMapFile = geoMapView.writeToPSFile(Strings.nullToEmpty((String)this.dataLabel), "ps");
            return new Data[]{DataFactory.forFile((File)outNetwork, (String)"file:text/nwb", (String)"Network", (Data)inDatum, (String)"Laid out network"), DataFactory.forFile((File)geoMapFile, (String)"file:text/ps", (String)"Vector Image", (Data)inDatum, (String)"Base map with anchor points")};
        }
        catch (TransformException e) {
            throw new AlgorithmExecutionException("Error transforming features: " + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new AlgorithmExecutionException("Error creating PostScript file: " + e.getMessage(), (Throwable)e);
        }
        catch (GeoMapViewPS.ShapefilePostScriptWriterException e) {
            throw new AlgorithmExecutionException("Error visualizing geo map: " + e.getMessage(), (Throwable)e);
        }
        catch (FactoryRegistryException e) {
            throw new AlgorithmExecutionException("Geography error: " + e.getMessage(), (Throwable)e);
        }
        catch (GeoMapException e) {
            throw new AlgorithmExecutionException("Error creating geo map: " + e.getMessage(), (Throwable)e);
        }
    }

    private File processNetwork(File inFile, Collection<Shapefile.AnchorPoint> anchorPoints, GeoMapViewPS geoMapView) throws AlgorithmExecutionException {
        try {
            File outFile = NWBFileUtilities.createTemporaryNWBFile();
            ParserPipe pipe = ParserPipe.create();
            pipe.addNodeAttribute(IS_ANCHOR_FIELD, "int", (Object)0);
            for (Shapefile.AnchorPoint anchorPoint : anchorPoints) {
                pipe.injectNode(anchorPoint.getDisplayName(), (Map)ImmutableMap.of((Object)this.longitudeAttrib, (Object)anchorPoint.getCoordinate().x, (Object)this.latitudeAttrib, (Object)anchorPoint.getCoordinate().y, (Object)IS_ANCHOR_FIELD, (Object)1));
            }
            pipe.addComputedNodeAttributes((Map)ImmutableMap.of((Object)X_POS_FIELD, (Object)"float", (Object)Y_POS_FIELD, (Object)"float"), (FieldMakerFunction)new LayoutFieldMakerFunction(geoMapView, this.longitudeAttrib, this.latitudeAttrib));
            new NWBFileParser(inFile).parse((NWBFileParserHandler)pipe.outputToFile(outFile));
            return outFile;
        }
        catch (IOException e) {
            throw new AlgorithmExecutionException("Error creating or parsing NWB file: " + e.getMessage(), (Throwable)e);
        }
        catch (ParsingException e) {
            throw new AlgorithmExecutionException("Error parsing NWB file: " + e.getMessage(), (Throwable)e);
        }
    }

    private static List<Circle> drawAnchorPoints(Collection<Shapefile.AnchorPoint> anchorPoints) {
        ArrayList circles = Lists.newArrayList();
        for (Shapefile.AnchorPoint anchorPoint : anchorPoints) {
            EnumMap strategies = Maps.newEnumMap(CircleDimension.class);
            strategies.put(CircleDimension.AREA, CircleAreaStrategy.forArea(5.0));
            strategies.put(CircleDimension.INNER_COLOR, new NullColorStrategy());
            strategies.put(CircleDimension.OUTER_COLOR, StrokeColorStrategy.theDefault());
            circles.add(new Circle(anchorPoint.getCoordinate(), strategies));
        }
        return circles;
    }

    public static void main(String[] args) {
        Example.NETWORK.run(new KnownProjectedCRSDescriptor[0]);
    }

    private static enum Example {
        NETWORK(Shapefile.WORLD, GeoMapsNetworkAlgorithm.class.getResource("/edu/iu/sci2/visualization/geomaps/testing/Network I 00-02.net.nwb"), "Network I 00-02", GeoMapsNetworkFactory.class, (ImmutableMap<String, Object>)ImmutableMap.builder().put((Object)GeoMapsNetworkFactory.Parameter.LATITUDE.id(), (Object)"latitude").put((Object)GeoMapsNetworkFactory.Parameter.LONGITUDE.id(), (Object)"longitude").build());

        private final Shapefile shapefile;
        private final URL networkFileURL;
        private final String dataLabel;
        private final Class<? extends AlgorithmFactory> algorithmFactoryClass;
        private final ImmutableMap<String, Object> baseParameters;

        private Example(Shapefile shapefile, URL networkFileURL, String dataLabel, Class<? extends AlgorithmFactory> algorithmFactoryClass, ImmutableMap<String, Object> baseParameters) {
            this.shapefile = shapefile;
            this.networkFileURL = networkFileURL;
            this.dataLabel = dataLabel;
            this.algorithmFactoryClass = algorithmFactoryClass;
            this.baseParameters = baseParameters;
        }

        private void run(String outputFilenamePrefix, Dictionary<String, Object> parameters) {
            try {
                LogStream.DEBUG.send("parameters are " + parameters, new Object[0]);
                Algorithm algorithm = Example.createAlgorithm(this.algorithmFactoryClass, this.networkFileURL, this.dataLabel, parameters);
                LogStream.DEBUG.send("Executing.. ", new Object[0]);
                Data[] outData = algorithm.execute();
                File nwbFileWithRawName = (File)outData[0].getData();
                File nwbFile = File.createTempFile(outputFilenamePrefix, ".nwb");
                Files.copy((File)nwbFileWithRawName, (File)nwbFile);
                LogStream.DEBUG.send(nwbFile.getAbsolutePath(), new Object[0]);
                File psFileWithRawName = (File)outData[1].getData();
                File psFile = File.createTempFile(outputFilenamePrefix, ".ps");
                Files.copy((File)psFileWithRawName, (File)psFile);
                LogStream.DEBUG.send(psFile.getAbsolutePath(), new Object[0]);
                LogStream.DEBUG.send(".. Done.", new Object[0]);
                Desktop.getDesktop().open(nwbFile);
            }
            catch (InstantiationException e) {
                LogStream.ERROR.send(e);
            }
            catch (IllegalAccessException e) {
                LogStream.ERROR.send(e);
            }
            catch (URISyntaxException e) {
                LogStream.ERROR.send(e);
            }
            catch (AlgorithmExecutionException e) {
                LogStream.ERROR.send(e);
            }
            catch (IOException e) {
                LogStream.ERROR.send(e);
            }
        }

        private void run(KnownProjectedCRSDescriptor ... explicitProjections) {
            Dictionary<String, Object> parameters = Example.assembleParameters(this.shapefile, this.baseParameters);
            if (explicitProjections.length == 0) {
                this.run("geo-viz-", parameters);
            } else {
                KnownProjectedCRSDescriptor[] knownProjectedCRSDescriptorArray = explicitProjections;
                int n = explicitProjections.length;
                int n2 = 0;
                while (n2 < n) {
                    KnownProjectedCRSDescriptor projection = knownProjectedCRSDescriptorArray[n2];
                    Hashtable<String, Object> freshParameters = new Hashtable<String, Object>((Hashtable)parameters);
                    ((Dictionary)freshParameters).put("projection", projection.getNiceName());
                    this.run("geo-viz-" + projection.getNiceName() + "-", freshParameters);
                    ++n2;
                }
            }
        }

        private static Dictionary<String, Object> assembleParameters(Shapefile shapefile, ImmutableMap<String, Object> baseParameters) {
            Hashtable<String, Object> parameters = new Hashtable<String, Object>();
            ((Dictionary)parameters).put(GeoMapsNetworkFactory.Parameter.SHAPEFILE_KEY.id(), shapefile.getNiceName());
            for (Map.Entry entry : baseParameters.entrySet()) {
                ((Dictionary)parameters).put((String)entry.getKey(), entry.getValue());
            }
            return parameters;
        }

        private static Algorithm createAlgorithm(Class<? extends AlgorithmFactory> algorithmFactoryClass, URL networkFileURL, String dataLabel, Dictionary<String, Object> parameters) throws InstantiationException, IllegalAccessException, URISyntaxException {
            AlgorithmFactory algorithmFactory = algorithmFactoryClass.newInstance();
            Data[] networkData = new Data[]{new BasicData((Object)new File(networkFileURL.toURI()), "file:text/nwb")};
            networkData[0].getMetadata().put("Label", dataLabel);
            CIShellContext ciContext = new CIShellContext(){

                public Object getService(String service) {
                    return null;
                }
            };
            return algorithmFactory.createAlgorithm(networkData, parameters, ciContext);
        }
    }

    private static final class LayoutFieldMakerFunction
    implements FieldMakerFunction {
        private final GeoMapViewPS geoMapView;
        private final String longitudeAttrib;
        private final String latitudeAttrib;

        private LayoutFieldMakerFunction(GeoMapViewPS geoMapView, String longitudeAttrib, String latitudeAttrib) {
            this.geoMapView = geoMapView;
            this.longitudeAttrib = longitudeAttrib;
            this.latitudeAttrib = latitudeAttrib;
        }

        public Map<String, Object> compute(Map<String, Object> attributes) {
            Preconditions.checkNotNull((Object)attributes.get(this.longitudeAttrib));
            Preconditions.checkNotNull((Object)attributes.get(this.latitudeAttrib));
            Coordinate longLat = new Coordinate(NumberUtilities.interpretObjectAsDouble((Object)attributes.get(this.longitudeAttrib)).doubleValue(), NumberUtilities.interpretObjectAsDouble((Object)attributes.get(this.latitudeAttrib)).doubleValue());
            try {
                Point2D.Double pagePoint = this.geoMapView.transformAndInsetToPagePoint(longLat);
                return ImmutableMap.of((Object)GeoMapsNetworkAlgorithm.X_POS_FIELD, (Object)pagePoint.x, (Object)GeoMapsNetworkAlgorithm.Y_POS_FIELD, (Object)pagePoint.y);
            }
            catch (TransformException e) {
                LogStream.WARNING.send(e, "Transform failure laying out node at coordinate %s.", longLat);
                return ImmutableMap.of();
            }
        }
    }
}

