/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.geomaps;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import edu.iu.sci2.visualization.geomaps.GeoMapsAlgorithm;
import edu.iu.sci2.visualization.geomaps.GeoMapsNetworkFactory;
import edu.iu.sci2.visualization.geomaps.LogStream;
import edu.iu.sci2.visualization.geomaps.data.scaling.Scaling;
import edu.iu.sci2.visualization.geomaps.metatype.Parameters;
import edu.iu.sci2.visualization.geomaps.viz.FeatureDimension;
import edu.iu.sci2.visualization.geomaps.viz.PageLayout;
import edu.iu.sci2.visualization.geomaps.viz.VizDimension;
import edu.iu.sci2.visualization.geomaps.viz.coding.AbstractColorCoding;
import edu.iu.sci2.visualization.geomaps.viz.model.RegionAnnotationMode;
import edu.iu.sci2.visualization.geomaps.viz.ps.HowToRead;
import java.util.Collection;
import java.util.Dictionary;
import java.util.EnumSet;
import java.util.List;
import org.antlr.stringtemplate.StringTemplate;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmCreationCanceledException;
import org.cishell.framework.algorithm.AlgorithmFactory;
import org.cishell.framework.algorithm.ParameterMutator;
import org.cishell.framework.data.Data;
import org.cishell.utilities.ColumnNotFoundException;
import org.cishell.utilities.TableUtilities;
import org.cishell.utilities.mutateParameter.dropdown.DropdownMutator;
import org.osgi.service.metatype.ObjectClassDefinition;
import prefuse.data.Table;

public abstract class GeoMapsRegionsFactory
implements AlgorithmFactory,
ParameterMutator {
    public static final String SUBTITLE = "Choropleth Map";
    public static final StringTemplate TEMPLATE_FOR_HOW_TO_READ = HowToRead.TEMPLATE_GROUP.getInstanceOf("choropleth");

    public Algorithm createAlgorithm(Data[] data, Dictionary<String, Object> parameters, CIShellContext ciShellContext) {
        String featureNameColumnName = (String)parameters.get("featureName");
        String dataLabel = (String)parameters.get(GeoMapsNetworkFactory.Parameter.DATA_LABEL.id());
        return new GeoMapsAlgorithm<String, FeatureDimension>(data, parameters, this.getPageLayout(), new RegionAnnotationMode(featureNameColumnName), dataLabel, SUBTITLE, TEMPLATE_FOR_HOW_TO_READ);
    }

    abstract PageLayout getPageLayout();

    public ObjectClassDefinition mutateParameters(Data[] data, ObjectClassDefinition oldOCD) {
        Table table = (Table)data[0].getData();
        Object numericColumnNames = ImmutableList.of();
        try {
            numericColumnNames = Lists.newArrayList((Object[])TableUtilities.getValidNumberColumnNamesInTable((Table)table));
        }
        catch (ColumnNotFoundException e) {
            LogStream.DEBUG.send(e, "No numeric table columns found.", new Object[0]);
        }
        Object stringColumnNames = ImmutableList.of();
        try {
            stringColumnNames = Lists.newArrayList((Object[])TableUtilities.getValidStringColumnNamesInTable((Table)table));
        }
        catch (ColumnNotFoundException e) {
            throw new AlgorithmCreationCanceledException("A text-valued column identifying US states or countries is required but no such column was detected.", (Throwable)e);
        }
        DropdownMutator mutator = new DropdownMutator();
        Parameters.addShapefileAndProjectionParameters(mutator);
        for (VizDimension vizDimension : EnumSet.allOf(FeatureDimension.class)) {
            vizDimension.addOptionsToAlgorithmParameters(mutator, (List<String>)numericColumnNames);
        }
        mutator.add("featureName", (Collection)stringColumnNames);
        mutator.add(FeatureDimension.REGION_COLOR.getScalingParameterId(), Collections2.transform(EnumSet.allOf(Scaling.class), (Function)Functions.toStringFunction()));
        mutator.add(FeatureDimension.REGION_COLOR.getRangeParameterId(), (Collection)AbstractColorCoding.COLOR_CONTINUUMS.keySet());
        return GeoMapsNetworkFactory.mutateSubtitleDefaultValue(data, mutator.mutate(oldOCD));
    }

    public static class Print
    extends GeoMapsRegionsFactory {
        @Override
        PageLayout getPageLayout() {
            return PageLayout.PRINT;
        }
    }

    public static class Web
    extends GeoMapsRegionsFactory {
        @Override
        PageLayout getPageLayout() {
            return PageLayout.WEB;
        }
    }
}

