/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.geomaps.data;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Range;
import com.google.common.collect.Ranges;
import com.google.common.collect.Sets;
import edu.iu.sci2.visualization.geomaps.LogStream;
import edu.iu.sci2.visualization.geomaps.data.GeoDatum;
import edu.iu.sci2.visualization.geomaps.data.scaling.ScalingException;
import edu.iu.sci2.visualization.geomaps.viz.AnnotationMode;
import edu.iu.sci2.visualization.geomaps.viz.VizDimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import prefuse.data.Table;
import prefuse.data.Tuple;

public class GeoDataset<G, D extends Enum<D>> {
    private final ImmutableCollection<GeoDatum<G, D>> geoData;
    private final ImmutableCollection<VizDimension.Binding<D>> bindings;

    private GeoDataset(Collection<? extends GeoDatum<G, D>> geoData, Collection<? extends VizDimension.Binding<D>> bindings) {
        this.geoData = ImmutableList.copyOf(geoData);
        this.bindings = ImmutableSet.copyOf(bindings);
    }

    public static <G, D extends Enum<D>> GeoDataset<G, D> fromTable(Table table, Collection<? extends VizDimension.Binding<D>> bindings, Class<D> dimensionClass, AnnotationMode.GeoIdentifierReader<G> geoIdentifierReader) {
        ImmutableMap<D, VizDimension.Binding<D>> dimensionToBinding = GeoDataset.mapDimensionsToBindings(bindings);
        int geoFailureCount = 0;
        int redundantCount = 0;
        int invalidCount = 0;
        HashSet geoIdentifiers = Sets.newHashSet();
        ArrayList geoData = Lists.newArrayListWithExpectedSize((int)table.getRowCount());
        Iterator tuples = table.tuples();
        while (tuples.hasNext()) {
            G geoIdentifier;
            Tuple tuple = (Tuple)tuples.next();
            try {
                geoIdentifier = geoIdentifierReader.readFrom(tuple);
            }
            catch (AnnotationMode.GeoIdentifierException e) {
                LogStream.DEBUG.send(e, "Failed to read geo identifier from tuple %s.", tuple);
                ++geoFailureCount;
                continue;
            }
            if (geoIdentifiers.contains(geoIdentifier)) {
                LogStream.DEBUG.send("Ignored tuple %s with redundant geo identifier %s.", tuple, geoIdentifier);
                ++redundantCount;
                continue;
            }
            geoIdentifiers.add(geoIdentifier);
            try {
                geoData.add(GeoDatum.forTuple(tuple, dimensionToBinding, dimensionClass, geoIdentifier));
            }
            catch (GeoDatum.GeoDatumValueInterpretationException e) {
                LogStream.DEBUG.send(e, "Skipped record %s with unusable values for the required attributes.", tuple);
                ++invalidCount;
            }
        }
        if (geoFailureCount > 0) {
            LogStream.WARNING.send("Ignored %d records with missing geo identifiers (coordinates or region names).", geoFailureCount);
        }
        if (redundantCount > 0) {
            LogStream.WARNING.send("Ignored %d records with redundant geo identifiers (coordinates or region names).  Consider aggregating this data before visualizing.", redundantCount);
        }
        if (invalidCount > 0) {
            LogStream.WARNING.send("Skipped %d records with unusable values for the required coding attributes.", invalidCount);
        }
        return new GeoDataset<G, D>(geoData, bindings);
    }

    public Collection<GeoDatum<G, D>> geoData(Stage stage) {
        return stage.transformTo(this);
    }

    public ImmutableCollection<VizDimension.Binding<D>> getBindings() {
        return this.bindings;
    }

    public Range<Double> calculateRangeOver(D dimension, Stage stage) {
        return Ranges.encloseAll((Iterable)Collections2.transform(stage.transformTo(this), (Function)new Function<GeoDatum<G, D>, Double>((Enum)dimension){
            private final /* synthetic */ Enum val$dimension;
            {
                this.val$dimension = enum_;
            }

            public Double apply(GeoDatum<G, D> geoDatum) {
                return geoDatum.valueInDimension(this.val$dimension);
            }
        }));
    }

    private static <D extends Enum<D>> ImmutableMap<D, ? extends VizDimension.Binding<D>> mapDimensionsToBindings(Collection<? extends VizDimension.Binding<D>> bindings) {
        return Maps.uniqueIndex(bindings, (Function)new Function<VizDimension.Binding<D>, D>(){

            public D apply(VizDimension.Binding<D> binding) {
                return binding.dimension();
            }
        });
    }

    public static enum Stage {
        RAW{

            @Override
            protected <G, D extends Enum<D>> Collection<GeoDatum<G, D>> transform(Collection<GeoDatum<G, D>> geoData, Collection<VizDimension.Binding<D>> bindings) {
                return geoData;
            }
        }
        ,
        SCALABLE{

            @Override
            protected <G, D extends Enum<D>> Collection<GeoDatum<G, D>> transform(Collection<GeoDatum<G, D>> geoData, Collection<VizDimension.Binding<D>> bindings) {
                return Collections2.filter(geoData, (Predicate)Predicates.and((Iterable)Collections2.transform(bindings, (Function)new Function<VizDimension.Binding<D>, Predicate<GeoDatum<G, D>>>(){

                    public Predicate<GeoDatum<G, D>> apply(final VizDimension.Binding<D> binding) {
                        return new Predicate<GeoDatum<G, D>>(){

                            public boolean apply(GeoDatum<G, D> geoDatum) {
                                return binding.isScalable(geoDatum);
                            }
                        };
                    }
                })));
            }
        }
        ,
        SCALED{

            @Override
            protected <G, D extends Enum<D>> Collection<GeoDatum<G, D>> transform(Collection<GeoDatum<G, D>> geoData, final Collection<VizDimension.Binding<D>> bindings) {
                return Collections2.transform(geoData, (Function)new Function<GeoDatum<G, D>, GeoDatum<G, D>>(){

                    public GeoDatum<G, D> apply(GeoDatum<G, D> geoDatum) {
                        GeoDatum scaled = geoDatum;
                        for (VizDimension.Binding binding : bindings) {
                            try {
                                scaled = GeoDatum.modifiedCopyOf(scaled, binding.dimension(), binding.scale(geoDatum));
                            }
                            catch (ScalingException scalingException) {
                                String message = String.format("The geo datum %s is not scalable by %s.", geoDatum, binding);
                                throw new AssertionError((Object)message);
                            }
                        }
                        return scaled;
                    }
                });
            }
        };


        protected abstract <G, D extends Enum<D>> Collection<GeoDatum<G, D>> transform(Collection<GeoDatum<G, D>> var1, Collection<VizDimension.Binding<D>> var2);

        public <G, D extends Enum<D>> Collection<GeoDatum<G, D>> transformTo(GeoDataset<G, D> geoDataset) {
            Object transformed = ((GeoDataset)geoDataset).geoData;
            for (Stage stage : EnumSet.range(Stage.values()[0], this)) {
                transformed = stage.transform((Collection<GeoDatum<G, D>>)transformed, (Collection<VizDimension.Binding<D>>)((GeoDataset)geoDataset).bindings);
            }
            return transformed;
        }
    }
}

