/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.geomaps.data;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import edu.iu.sci2.visualization.geomaps.viz.VizDimension;
import java.util.EnumMap;
import java.util.Map;
import org.cishell.utilities.NumberUtilities;
import prefuse.data.Tuple;

public class GeoDatum<G, D extends Enum<D>> {
    private final G geo;
    private final EnumMap<D, Double> values;

    private GeoDatum(G geo, EnumMap<D, Double> values) {
        this.geo = geo;
        this.values = Maps.newEnumMap(values);
    }

    public static <G, D extends Enum<D>> GeoDatum<G, D> of(G geo, EnumMap<D, Double> values) {
        return new GeoDatum<G, D>(geo, values);
    }

    public static <G, D extends Enum<D>> GeoDatum<G, D> modifiedCopyOf(GeoDatum<G, D> geoDatum, D dimension, Double newValue) {
        return GeoDatum.modifiedCopyOf(geoDatum, Maps.newEnumMap((Map)ImmutableMap.of(dimension, (Object)newValue)));
    }

    public static <G, D extends Enum<D>> GeoDatum<G, D> modifiedCopyOf(GeoDatum<G, D> geoDatum, EnumMap<D, Double> overridingValues) {
        EnumMap updatedValues = Maps.newEnumMap(geoDatum.values);
        updatedValues.putAll(overridingValues);
        return GeoDatum.of(geoDatum.geo, updatedValues);
    }

    public static <G, D extends Enum<D>> GeoDatum<G, D> forTuple(Tuple tuple, Map<D, ? extends VizDimension.Binding<D>> dimensionToBinding, Class<D> dimensionClass, G geoIdentifier) throws GeoDatumValueInterpretationException {
        EnumMap dimensionToValue = Maps.newEnumMap(dimensionClass);
        for (Map.Entry<D, VizDimension.Binding<D>> dimensionAndBinding : dimensionToBinding.entrySet()) {
            Enum dimension = (Enum)dimensionAndBinding.getKey();
            VizDimension.Binding<D> binding = dimensionAndBinding.getValue();
            Object valueObject = tuple.get(binding.columnName());
            if (valueObject == null) {
                throw new GeoDatumValueInterpretationException(String.format("No value specified in dimension %s for tuple %s.", dimension, tuple));
            }
            try {
                double value = NumberUtilities.interpretObjectAsDouble((Object)valueObject);
                dimensionToValue.put(dimension, value);
            }
            catch (NumberFormatException e) {
                throw new GeoDatumValueInterpretationException(String.format("Value \"%s\" specified in dimension %s for tuple %s couldn't be interpreted as a number.", String.valueOf(valueObject), dimension, tuple), e);
            }
        }
        return GeoDatum.of(geoIdentifier, dimensionToValue);
    }

    public G getGeo() {
        return this.geo;
    }

    public Double valueInDimension(D dimension) {
        return this.values.get(dimension);
    }

    public boolean equals(Object thatObject) {
        if (this == thatObject) {
            return true;
        }
        if (thatObject == null) {
            return false;
        }
        if (!(thatObject instanceof GeoDatum)) {
            return false;
        }
        GeoDatum that = (GeoDatum)thatObject;
        return Objects.equal(this.geo, that.geo) && Objects.equal(this.values, that.values);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.geo, this.values});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("geo", this.geo).add("values", this.values).toString();
    }

    public static class GeoDatumValueInterpretationException
    extends Exception {
        private static final long serialVersionUID = 8535808482844659436L;

        private GeoDatumValueInterpretationException(String message, Throwable cause) {
            super(message, cause);
        }

        private GeoDatumValueInterpretationException(String message) {
            super(message);
        }
    }
}

