/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.geomaps.data.interpolation;

import com.google.common.collect.Range;
import edu.iu.sci2.visualization.geomaps.data.interpolation.Interpolator;
import edu.iu.sci2.visualization.geomaps.data.interpolation.InterpolatorND;
import edu.iu.sci2.visualization.geomaps.utility.ColorTuples;
import edu.iu.sci2.visualization.geomaps.utility.Continuum;
import java.awt.Color;

public class ColorInterpolator
implements Interpolator<Color> {
    private final InterpolatorND interpolator3D;

    private ColorInterpolator(Range<Double> inRange, Continuum<Color> colorContinuum) {
        double[] outMinTuple = ColorTuples.asTuple(colorContinuum.getPointA());
        double[] outMaxTuple = ColorTuples.asTuple(colorContinuum.getPointB());
        this.interpolator3D = InterpolatorND.between(inRange, Continuum.between(outMinTuple, outMaxTuple));
    }

    public static ColorInterpolator between(Range<Double> inRange, Continuum<Color> colorContinuum) {
        return new ColorInterpolator(inRange, colorContinuum);
    }

    @Override
    public Color apply(Double value) {
        return ColorTuples.asColor(this.interpolator3D.apply(value));
    }

    @Override
    public Range<Double> getInRange() {
        return this.interpolator3D.getInRange();
    }

    @Override
    public Continuum<Color> getOutContinuum() {
        return Continuum.between(ColorTuples.asColor(this.interpolator3D.getOutContinuum().getPointA()), ColorTuples.asColor(this.interpolator3D.getOutContinuum().getPointB()));
    }
}

