/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.geomaps.data.interpolation;

import com.google.common.collect.Range;
import edu.iu.sci2.visualization.geomaps.data.interpolation.Interpolator;
import edu.iu.sci2.visualization.geomaps.utility.Continuum;

public class Interpolator1D
implements Interpolator<Double> {
    private final Range<Double> inRange;
    private final Continuum<Double> outContinuum;

    private Interpolator1D(Range<Double> inRange, Continuum<Double> outContinuum) {
        this.inRange = inRange;
        this.outContinuum = outContinuum;
    }

    public static Interpolator1D between(Range<Double> inRange, Continuum<Double> outContinuum) {
        return new Interpolator1D(inRange, outContinuum);
    }

    @Override
    public Double apply(Double value) {
        return Interpolator1D.interpolate(value, this.inRange, this.outContinuum);
    }

    private static double interpolate(double value, Range<Double> inRange, Continuum<Double> outContinuum) {
        return Interpolator1D.interpolate(value, (Double)inRange.lowerEndpoint(), (Double)inRange.upperEndpoint(), outContinuum.getPointA(), outContinuum.getPointB());
    }

    private static double interpolate(double in, double inMin, double inMax, double outMin, double outMax) {
        if (inMax - inMin == 0.0) {
            return outMin;
        }
        return outMin + (in - inMin) * (outMax - outMin) / (inMax - inMin);
    }

    @Override
    public Range<Double> getInRange() {
        return this.inRange;
    }

    @Override
    public Continuum<Double> getOutContinuum() {
        return this.outContinuum;
    }
}

