/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.geomaps.data.interpolation;

import com.google.common.base.Preconditions;
import com.google.common.collect.Range;
import edu.iu.sci2.visualization.geomaps.data.interpolation.Interpolator;
import edu.iu.sci2.visualization.geomaps.data.interpolation.Interpolator1D;
import edu.iu.sci2.visualization.geomaps.utility.Continuum;

public class InterpolatorND
implements Interpolator<double[]> {
    private final Range<Double> inRange;
    private final Continuum<double[]> outContinuum;
    private final Interpolator1D[] interpolators;

    private InterpolatorND(Range<Double> inRange, Continuum<double[]> outContinuum) {
        Preconditions.checkArgument((outContinuum.getPointA().length == outContinuum.getPointB().length ? 1 : 0) != 0, (Object)"Endpoints of the output continuum must have the same dimensionality.");
        this.inRange = inRange;
        this.outContinuum = outContinuum;
        int dimensionality = outContinuum.getPointA().length;
        this.interpolators = new Interpolator1D[dimensionality];
        int dd = 0;
        while (dd < dimensionality) {
            this.interpolators[dd] = Interpolator1D.between(inRange, Continuum.between(outContinuum.getPointA()[dd], outContinuum.getPointB()[dd]));
            ++dd;
        }
    }

    public static InterpolatorND between(Range<Double> inRange, Continuum<double[]> outContinuum) {
        return new InterpolatorND(inRange, outContinuum);
    }

    @Override
    public double[] apply(Double value) {
        double[] tuple = new double[this.interpolators.length];
        int dd = 0;
        while (dd < tuple.length) {
            tuple[dd] = this.interpolators[dd].apply(value);
            ++dd;
        }
        return tuple;
    }

    @Override
    public Range<Double> getInRange() {
        return this.inRange;
    }

    @Override
    public Continuum<double[]> getOutContinuum() {
        return this.outContinuum;
    }
}

