/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.geomaps.data.scaling;

import edu.iu.sci2.visualization.geomaps.LogStream;
import edu.iu.sci2.visualization.geomaps.data.scaling.ScalingException;

public enum Scaling {
    Linear{

        @Override
        protected double scaleUnchecked(double value) {
            return value;
        }

        @Override
        public Scaling inverse() {
            return Linear;
        }
    }
    ,
    Logarithmic{

        @Override
        protected double scaleUnchecked(double value) {
            return Math.log10(value);
        }

        @Override
        public Scaling inverse() {
            return Exponential;
        }
    }
    ,
    Exponential{

        @Override
        protected double scaleUnchecked(double value) {
            return Math.pow(10.0, value);
        }

        @Override
        public Scaling inverse() {
            return Logarithmic;
        }
    };


    private Scaling() {
    }

    protected abstract double scaleUnchecked(double var1);

    public abstract Scaling inverse();

    public double scale(double value) throws ScalingException {
        double unchecked = this.scaleUnchecked(value);
        if (Double.isInfinite(unchecked) || Double.isNaN(unchecked)) {
            throw new ScalingException(String.format("Scaling \"%s\" cannot scale the value \"%s\".", new Object[]{this, value}));
        }
        return unchecked;
    }

    public double invert(double value) throws ScalingException {
        return this.inverse().scale(value);
    }

    public boolean isScalable(double value) {
        try {
            this.scale(value);
            return true;
        }
        catch (ScalingException e) {
            LogStream.DEBUG.send(e, "Failed to scale value %f.", value);
            return false;
        }
    }

    /* synthetic */ Scaling(String string, int n, Scaling scaling) {
        this();
    }
}

