/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.geomaps.geo.projection;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import org.geotools.geometry.jts.JTSFactoryFinder;

class CropGeometries {
    static final double MERIDIAN_CROP_WIDTH_AT_EQUATOR = 0.01;
    static final double MIN_LATITUDE = -90.0;
    static final double EQUATOR_LATITUDE = 0.0;
    static final double MAX_LATITUDE = 90.0;
    static final double MIN_LONGITUDE = -180.0;
    static final double MAX_LONGITUDE = 180.0;

    CropGeometries() {
    }

    static Geometry aroundMeridian(double meridian) {
        GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory(null);
        Coordinate northPole = new Coordinate(meridian, 90.0);
        Coordinate equatorEpsilonEast = new Coordinate(meridian + 0.01, 0.0);
        Coordinate equatorEpsilonWest = new Coordinate(meridian - 0.01, 0.0);
        Coordinate southPole = new Coordinate(meridian, -90.0);
        LineString easternLine = geometryFactory.createLineString(new Coordinate[]{northPole, equatorEpsilonEast, southPole});
        LineString westernLine = geometryFactory.createLineString(new Coordinate[]{northPole, equatorEpsilonWest, southPole});
        return easternLine.union((Geometry)westernLine).convexHull();
    }

    static Geometry aroundNorthPole(double cropHeightInDegreesLatitude) {
        return CropGeometries.betweenTwoLatitudes(90.0, 90.0 - cropHeightInDegreesLatitude);
    }

    static Geometry aroundSouthPole(double cropHeightInDegreesLatitude) {
        return CropGeometries.betweenTwoLatitudes(-90.0, -90.0 + cropHeightInDegreesLatitude);
    }

    static Geometry betweenTwoLatitudes(double latitude1, double latitude2) {
        GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory(null);
        LinearRing border = geometryFactory.createLinearRing(new Coordinate[]{new Coordinate(-180.0, latitude1), new Coordinate(-180.0, latitude2), new Coordinate(180.0, latitude2), new Coordinate(180.0, latitude1), new Coordinate(-180.0, latitude1)});
        return border.convexHull();
    }
}

