/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.geomaps.geo.projection;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import edu.iu.sci2.visualization.geomaps.geo.projection.CropGeometries;
import edu.iu.sci2.visualization.geomaps.geo.projection.KnownProjectedCRSDescriptor;
import org.geotools.geometry.jts.GeometryCoordinateSequenceTransformer;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.operation.Projection;
import org.opengis.referencing.operation.TransformException;

public class GeometryProjector {
    private static final GeometryFactory GEOMETRY_FACTORY = JTSFactoryFinder.getGeometryFactory(null);
    public static final String CENTRAL_MERIDIAN_PARAMETER_KEY = "central_meridian";
    public static final double MAX_LONGITUDE = 180.0;
    public static final double NORTH_POLE_CROP_HEIGHT_IN_DEGREES = 10.0;
    public static final double SOUTH_POLE_CROP_HEIGHT_IN_DEGREES = 12.0;
    private final GeometryCoordinateSequenceTransformer transformer = new GeometryCoordinateSequenceTransformer();
    private final Geometry cropGeometry;

    public GeometryProjector(CoordinateReferenceSystem sourceCrs, KnownProjectedCRSDescriptor knownProjectedCRSDescriptor) throws GeometryProjectorException {
        try {
            this.transformer.setMathTransform(knownProjectedCRSDescriptor.getTransformFrom(sourceCrs));
            this.cropGeometry = GeometryProjector.createCropGeometry(knownProjectedCRSDescriptor);
        }
        catch (FactoryException e) {
            throw new GeometryProjectorException("Failed to create projection", e);
        }
    }

    private static Geometry createCropGeometry(KnownProjectedCRSDescriptor knownProjectedCRSDescriptor) throws GeometryProjectorException, NoSuchAuthorityCodeException, FactoryException {
        double oppositeOfCentralMeridian = GeometryProjector.getOppositeLongitude(GeometryProjector.centralMeridianOf(knownProjectedCRSDescriptor.asProjectedCRS()));
        return GeometryProjector.union(CropGeometries.aroundMeridian(oppositeOfCentralMeridian), CropGeometries.aroundNorthPole(10.0), CropGeometries.aroundSouthPole(12.0));
    }

    private static Geometry union(Geometry first, Geometry ... rest) {
        Geometry union = (Geometry)first.clone();
        Geometry[] geometryArray = rest;
        int n = rest.length;
        int n2 = 0;
        while (n2 < n) {
            Geometry g = geometryArray[n2];
            union = union.union(g);
            ++n2;
        }
        return union;
    }

    public Geometry cropAndTransformGeometry(Geometry originalGeometry) throws TransformException {
        return this.transformer.transform(originalGeometry.difference(this.cropGeometry));
    }

    public Point transformCoordinate(Coordinate coordinate) throws TransformException {
        Point point = GEOMETRY_FACTORY.createPoint(coordinate);
        return this.transformer.transformPoint(point, GEOMETRY_FACTORY);
    }

    private static double getOppositeLongitude(double longitude) {
        return longitude >= 0.0 ? longitude - 180.0 : longitude + 180.0;
    }

    private static double centralMeridianOf(ProjectedCRS projectedCRS) throws GeometryProjectorException {
        Projection projection = projectedCRS.getConversionFromBase();
        ParameterValueGroup parameterValues = projection.getParameterValues();
        ParameterValue centralMeridianParameter = parameterValues.parameter(CENTRAL_MERIDIAN_PARAMETER_KEY);
        if (centralMeridianParameter == null) {
            throw new GeometryProjectorException("No central meridian specified.");
        }
        return centralMeridianParameter.doubleValue();
    }

    public static class GeometryProjectorException
    extends Exception {
        private static final long serialVersionUID = -2240465725004904181L;

        public GeometryProjectorException(String message, Throwable cause) {
            super(message, cause);
        }

        public GeometryProjectorException(String message) {
            super(message);
        }
    }
}

