/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.geomaps.geo.projection;

import com.google.common.base.Objects;
import edu.iu.sci2.visualization.geomaps.geo.projection.ProjectedCRSDescriptor;
import edu.iu.sci2.visualization.geomaps.geo.shapefiles.Shapefile;
import edu.iu.sci2.visualization.geomaps.utility.NicelyNamedEnums;
import org.geotools.referencing.CRS;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.operation.MathTransform;

public enum KnownProjectedCRSDescriptor implements ProjectedCRSDescriptor,
NicelyNamedEnums.NicelyNamed
{
    ECKERT_IV("Eckert IV", "equal-area Eckert IV", new EPSGCode("EPSG:54012")),
    MERCATOR("Mercator", "Mercator", new EPSGCode("EPSG:3395")),
    ALBERS("Albers Equal-Area Conic", "Albers equal-area conic", new EPSGCode("EPSG:3083")),
    LAMBERT("Lambert Conformal Conic", "Lambert conformal conic", new EPSGCode("EPSG:102004"));

    public static final boolean REQUEST_LENIENT_TRANSFORM = true;
    private final String niceName;
    private final String description;
    private final ProjectedCRSDescriptor projectedCrsDescriptor;

    private KnownProjectedCRSDescriptor(String niceName, String description, ProjectedCRSDescriptor crsMaker) {
        this.niceName = niceName;
        this.description = description;
        this.projectedCrsDescriptor = crsMaker;
    }

    @Override
    public String getNiceName() {
        return this.niceName;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public ProjectedCRS asProjectedCRS() throws NoSuchAuthorityCodeException, FactoryException {
        return this.projectedCrsDescriptor.asProjectedCRS();
    }

    public MathTransform getTransformFrom(CoordinateReferenceSystem sourceCrs) throws NoSuchAuthorityCodeException, FactoryException {
        return CRS.findMathTransform((CoordinateReferenceSystem)((CoordinateReferenceSystem)Objects.firstNonNull((Object)sourceCrs, (Object)Shapefile.FALLBACK_SOURCE_CRS)), (CoordinateReferenceSystem)this.asProjectedCRS(), (boolean)true);
    }

    private static final class EPSGCode
    implements ProjectedCRSDescriptor {
        private final String code;

        EPSGCode(String code) {
            this.code = code;
        }

        @Override
        public ProjectedCRS asProjectedCRS() throws NoSuchAuthorityCodeException, FactoryException {
            return CRS.getProjectedCRS((CoordinateReferenceSystem)CRS.decode((String)this.code));
        }
    }
}

