/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.geomaps.geo.shapefiles;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.Resources;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import edu.iu.sci2.visualization.geomaps.geo.projection.GeometryProjector;
import edu.iu.sci2.visualization.geomaps.geo.projection.KnownProjectedCRSDescriptor;
import edu.iu.sci2.visualization.geomaps.utility.NicelyNamedEnums;
import edu.iu.sci2.visualization.geomaps.viz.model.RegionAnnotationMode;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.filter.text.cql2.CQL;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public enum Shapefile implements NicelyNamedEnums.NicelyNamed
{
    UNITED_STATES(Resources.getResource(Shapefile.class, (String)"st99_d00.shp"), "United States", "%d U.S. states and other jurisdictions", "U.S. State", "U.S. state", "NAME", KnownProjectedCRSDescriptor.ALBERS, (Collection<Inset.Request>)ImmutableSet.of((Object)Inset.Request.ALASKA, (Object)Inset.Request.HAWAII, (Object)Inset.Request.PUERTO_RICO), (Collection<AnchorPoint>)ImmutableSet.of((Object)AnchorPoint.NEAR_WASHINGTON, (Object)AnchorPoint.NEAR_FLORIDA)),
    WORLD(Resources.getResource(Shapefile.class, (String)"countries.shp"), "World", "%d countries of the world", "Country", "country", "NAME", KnownProjectedCRSDescriptor.ECKERT_IV, (Collection<Inset.Request>)ImmutableSet.of(), (Collection<AnchorPoint>)ImmutableSet.of((Object)AnchorPoint.NEAR_ALASKA, (Object)AnchorPoint.NEAR_ANTARCTICA));

    public static final DefaultGeographicCRS FALLBACK_SOURCE_CRS;
    private final String niceName;
    private final String mapDescriptionFormat;
    private final String componentDescriptionTitleCase;
    private final String componentDescriptionPlain;
    private final String featureAttributeName;
    private final KnownProjectedCRSDescriptor defaultProjectedCrs;
    private final FeatureSource<SimpleFeatureType, SimpleFeature> featureSource;
    private final ImmutableCollection<Inset.Request> insetRequests;
    private final ImmutableCollection<AnchorPoint> anchorPoints;
    private final String shapefileTypeName;

    static {
        FALLBACK_SOURCE_CRS = DefaultGeographicCRS.WGS84;
    }

    private Shapefile(URL url, String niceName, String mapDescriptionFormat, String componentDescriptionTitleCase, String componentDescriptionPlain, String featureAttributeName, KnownProjectedCRSDescriptor defaultProjectedCrs, Collection<Inset.Request> insetRequests, Collection<AnchorPoint> anchorPoints) throws ShapefileException {
        this.niceName = niceName;
        this.mapDescriptionFormat = mapDescriptionFormat;
        this.componentDescriptionTitleCase = componentDescriptionTitleCase;
        this.componentDescriptionPlain = componentDescriptionPlain;
        this.featureAttributeName = featureAttributeName;
        this.defaultProjectedCrs = defaultProjectedCrs;
        this.anchorPoints = ImmutableSet.copyOf(anchorPoints);
        this.insetRequests = ImmutableSet.copyOf(insetRequests);
        try {
            ShapefileDataStore dataStore = new ShapefileDataStore(url);
            this.shapefileTypeName = dataStore.getTypeNames()[0];
            this.featureSource = dataStore.getFeatureSource(this.shapefileTypeName);
        }
        catch (IOException e) {
            throw new ShapefileException("The shapefile data store could not be opened.", e);
        }
    }

    public ReferencedEnvelope boundsForFeatureName(String featureName) throws FeatureBoundsDetectionException {
        try {
            Query query = new Query(this.shapefileTypeName, CQL.toFilter((String)String.format("NAME = '%s'", featureName)));
            return this.featureSource.getFeatures(query).getBounds();
        }
        catch (CQLException e) {
            throw new FeatureBoundsDetectionException(String.format("Failed to create feature filter for inset \"%s\".", featureName), e);
        }
        catch (IOException e) {
            throw new FeatureBoundsDetectionException(String.format("Failed to read features for inset \"%s\".", featureName), e);
        }
    }

    public CoordinateReferenceSystem detectNativeCRS() {
        return (CoordinateReferenceSystem)Objects.firstNonNull((Object)((SimpleFeatureType)this.featureSource.getSchema()).getCoordinateReferenceSystem(), (Object)FALLBACK_SOURCE_CRS);
    }

    public String extractFeatureName(SimpleFeature feature) {
        Object featureName = feature.getAttribute(this.featureAttributeName);
        if (featureName != null) {
            return RegionAnnotationMode.normalizeFeatureName(String.valueOf(featureName));
        }
        String message = String.format("Feature %s has no \"%s\" property.  ", feature, this.featureAttributeName);
        message = String.valueOf(message) + "Consider using one of these properties: ";
        ArrayList attributeDescriptorNames = Lists.newArrayList();
        for (AttributeDescriptor attributeDescriptor : ((SimpleFeatureType)this.viewOfFeatureCollection().getSchema()).getAttributeDescriptors()) {
            attributeDescriptorNames.add(attributeDescriptor.getName().toString());
        }
        message = String.valueOf(message) + Joiner.on((String)",").join((Iterable)attributeDescriptorNames);
        throw new FeatureAttributeAbsentException(message);
    }

    public String toString() {
        return this.niceName;
    }

    public boolean hasInsets() {
        return !this.insetRequests.isEmpty();
    }

    @Override
    public String getNiceName() {
        return this.niceName;
    }

    public String makeMapDescription() {
        HashSet uniqueFeatureNames = Sets.newHashSet();
        FeatureIterator it = this.viewOfFeatureCollection().features();
        try {
            while (it.hasNext()) {
                uniqueFeatureNames.add(this.extractFeatureName((SimpleFeature)it.next()));
            }
        }
        finally {
            it.close();
        }
        return String.format(this.mapDescriptionFormat, uniqueFeatureNames.size());
    }

    public String getComponentDescriptionTitleCase() {
        return this.componentDescriptionTitleCase;
    }

    public String getComponentDescriptionPlain() {
        return this.componentDescriptionPlain;
    }

    public String getFeatureAttributeName() {
        return this.featureAttributeName;
    }

    public KnownProjectedCRSDescriptor getDefaultProjectedCrs() {
        return this.defaultProjectedCrs;
    }

    public ImmutableCollection<AnchorPoint> getAnchorPoints() {
        return this.anchorPoints;
    }

    public ImmutableCollection<Inset.Request> getInsetRequests() {
        return this.insetRequests;
    }

    public FeatureCollection<SimpleFeatureType, SimpleFeature> viewOfFeatureCollection() throws ShapefileFeatureRetrievalException {
        try {
            return this.featureSource.getFeatures();
        }
        catch (IOException e) {
            throw new ShapefileFeatureRetrievalException("Error accessing shapefile: " + e.getMessage(), e);
        }
    }

    public static class AnchorPoint {
        public static final AnchorPoint NEAR_ALASKA = AnchorPoint.at("Near Alaska", new Coordinate(-179.0, 79.0));
        public static final AnchorPoint NEAR_WASHINGTON = AnchorPoint.at("Near Aleutian Islands", new Coordinate(-127.0, 49.0));
        public static final AnchorPoint NEAR_ANTARCTICA = AnchorPoint.at("Near Antarctica", new Coordinate(179.0, -77.0));
        public static final AnchorPoint NEAR_FLORIDA = AnchorPoint.at("Near Puerto Rico", new Coordinate(-79.0, 24.0));
        private final String displayName;
        private final Coordinate coordinate;

        private AnchorPoint(String displayName, Coordinate coordinate) {
            this.displayName = displayName;
            this.coordinate = coordinate;
        }

        public static AnchorPoint at(String displayName, Coordinate coordinate) {
            return new AnchorPoint(displayName, coordinate);
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public Coordinate getCoordinate() {
            return this.coordinate;
        }

        public boolean equals(Object thatObject) {
            if (this == thatObject) {
                return true;
            }
            if (thatObject == null) {
                return false;
            }
            if (!(thatObject instanceof AnchorPoint)) {
                return false;
            }
            AnchorPoint that = (AnchorPoint)thatObject;
            return Objects.equal((Object)this.displayName, (Object)that.displayName) && Objects.equal((Object)this.coordinate, (Object)that.coordinate);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.displayName, this.coordinate});
        }
    }

    public static class FeatureAttributeAbsentException
    extends RuntimeException {
        private static final long serialVersionUID = -6714673548077059632L;

        public FeatureAttributeAbsentException(String message) {
            super(message);
        }
    }

    public static class FeatureBoundsDetectionException
    extends Exception {
        private static final long serialVersionUID = -2452894524543314017L;

        public FeatureBoundsDetectionException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class Inset {
        private final Request request;
        private final ReferencedEnvelope bounds;
        private final AffineTransform2D transform;

        private Inset(Request request, ReferencedEnvelope bounds, AffineTransform2D transform) {
            this.request = request;
            this.bounds = bounds;
            this.transform = transform;
        }

        public static Inset forRequest(Request request, Shapefile shapefile, GeometryProjector projector) throws InsetCreationException {
            try {
                return new Inset(request, shapefile.boundsForFeatureName(request.getFeatureName()), Inset.createTransform(request, projector));
            }
            catch (FeatureBoundsDetectionException e) {
                throw new InsetCreationException(String.format("Failed to detect bounding box of the \"%s\" inset.", request.getFeatureName()), e);
            }
            catch (TransformException e) {
                throw new InsetCreationException(String.format("Failed to create transform for inset of \"%s\".", request.getFeatureName()), e);
            }
        }

        private static AffineTransform2D createTransform(Request request, GeometryProjector projector) throws TransformException {
            Point naturalPoint = projector.transformCoordinate(request.getNaturalAnchor());
            AffineTransform preScale = AffineTransform.getTranslateInstance(-naturalPoint.getX(), -naturalPoint.getY());
            AffineTransform scale = AffineTransform.getScaleInstance(request.calculateDimensionScaling(), request.calculateDimensionScaling());
            Point insetPoint = projector.transformCoordinate(request.getInsetAnchor());
            AffineTransform postScale = AffineTransform.getTranslateInstance(insetPoint.getX(), insetPoint.getY());
            return new AffineTransform2D(Inset.preConcatenate(preScale, scale, postScale));
        }

        public boolean shouldInsetCoordinate(Coordinate coordinate) {
            return this.bounds.contains(coordinate);
        }

        public boolean shouldInset(Geometry geometry) {
            return this.bounds.contains(geometry.getEnvelopeInternal());
        }

        public Point insetPoint(Point projectedPoint) {
            try {
                Coordinate coordinate = new Coordinate();
                JTS.transform((Coordinate)projectedPoint.getCoordinate(), (Coordinate)coordinate, (MathTransform)this.transform);
                return JTSFactoryFinder.getGeometryFactory(null).createPoint(coordinate);
            }
            catch (TransformException e) {
                throw new RuntimeException("Inset transform failed.", e);
            }
        }

        public Geometry inset(Geometry projectedGeometry) {
            try {
                return JTS.transform((Geometry)projectedGeometry, (MathTransform)this.transform);
            }
            catch (TransformException e) {
                throw new RuntimeException("Inset transform failed.", e);
            }
        }

        public String makeLabel() {
            if (Math.abs(this.request.getAreaScaling() - 1.0) < 0.001) {
                return this.request.getFeatureName();
            }
            return String.format("%s (%d%% actual area)", this.request.getFeatureName(), (int)(100.0 * this.request.getAreaScaling()));
        }

        public Coordinate getLabelLowerLeft() {
            return this.request.getLabelLowerLeft();
        }

        private static AffineTransform preConcatenate(AffineTransform first, AffineTransform ... rest) {
            AffineTransform concat = (AffineTransform)first.clone();
            AffineTransform[] affineTransformArray = rest;
            int n = rest.length;
            int n2 = 0;
            while (n2 < n) {
                AffineTransform subsequent = affineTransformArray[n2];
                concat.preConcatenate(subsequent);
                ++n2;
            }
            return concat;
        }

        public static class InsetCreationException
        extends Exception {
            private static final long serialVersionUID = 5491622047581675511L;

            public InsetCreationException(String message, Throwable cause) {
                super(message, cause);
            }
        }

        public static class Request {
            public static final Request ALASKA = new Request("Alaska", new Coordinate(-160.0, 41.0), 0.1, new Coordinate(-131.0, 55.0), new Coordinate(-127.0, 42.0));
            public static final Request HAWAII = new Request("Hawaii", new Coordinate(-159.0, 14.0), 0.5, new Coordinate(-155.0, 20.0), new Coordinate(-126.0, 30.0));
            public static final Request PUERTO_RICO = new Request("Puerto Rico", new Coordinate(-68.7, 17.0), 1.0, new Coordinate(-66.0, 18.0), new Coordinate(-129.0, 37.0));
            private final String featureName;
            private final Coordinate labelLowerLeft;
            private final double areaScaling;
            private final Coordinate naturalAnchor;
            private final Coordinate insetAnchor;

            public Request(String featureName, Coordinate labelLowerLeft, double areaScaling, Coordinate naturalAnchor, Coordinate insetAnchor) {
                this.featureName = featureName;
                this.labelLowerLeft = labelLowerLeft;
                this.areaScaling = areaScaling;
                this.naturalAnchor = naturalAnchor;
                this.insetAnchor = insetAnchor;
            }

            public String getFeatureName() {
                return this.featureName;
            }

            public Coordinate getLabelLowerLeft() {
                return this.labelLowerLeft;
            }

            public double getAreaScaling() {
                return this.areaScaling;
            }

            public double calculateDimensionScaling() {
                return Math.sqrt(this.areaScaling);
            }

            public Coordinate getNaturalAnchor() {
                return this.naturalAnchor;
            }

            public Coordinate getInsetAnchor() {
                return this.insetAnchor;
            }
        }
    }

    public static class ShapefileException
    extends RuntimeException {
        private static final long serialVersionUID = -9175935612884445370L;

        public ShapefileException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class ShapefileFeatureRetrievalException
    extends RuntimeException {
        private static final long serialVersionUID = -5812550122559595790L;

        public ShapefileFeatureRetrievalException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

