/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.geomaps.metatype;

import com.google.common.base.Function;
import com.google.common.collect.Ordering;
import edu.iu.sci2.visualization.geomaps.GeoMapsNetworkFactory;
import edu.iu.sci2.visualization.geomaps.geo.shapefiles.Shapefile;
import edu.iu.sci2.visualization.geomaps.utility.NicelyNamedEnums;
import edu.iu.sci2.visualization.geomaps.utility.SubstringOrderings;
import java.util.Collection;
import java.util.List;
import org.cishell.utilities.ToCaseFunction;
import org.cishell.utilities.mutateParameter.dropdown.DropdownMutator;

public class Parameters {
    public static final String PROJECTION_ID = "projection";
    public static final boolean LET_USER_CHOOSE_PROJECTION = false;
    public static final Ordering<String> LATITUDISHNESS = SubstringOrderings.explicit("y", "l", "lt", "lat", "lat.", "latitude").onResultOf((Function)ToCaseFunction.LOWER);
    public static final Ordering<String> LONGITUDISHNESS = SubstringOrderings.explicit("x", "l", "ln", "lg", "long", "lng", "longitude").onResultOf((Function)ToCaseFunction.LOWER);

    public static void addLatitudeParameter(DropdownMutator mutator, List<String> columnNames, String parameterId) {
        mutator.add(parameterId, (Collection)LATITUDISHNESS.reverse().sortedCopy(columnNames));
    }

    public static void addLongitudeParameter(DropdownMutator mutator, List<String> columnNames, String parameterId) {
        mutator.add(parameterId, (Collection)LONGITUDISHNESS.reverse().sortedCopy(columnNames));
    }

    public static void addShapefileAndProjectionParameters(DropdownMutator mutator) {
        mutator.add(GeoMapsNetworkFactory.Parameter.SHAPEFILE_KEY.id(), NicelyNamedEnums.allNiceNamesOf(Shapefile.class));
        mutator.ignore(PROJECTION_ID);
    }
}

