/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.geomaps.utility;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Doubles;
import java.util.Collection;

public class Averages {
    public static final String FAIL_MESSAGE = "Cannot take the mean of zero numbers.";

    private Averages() {
    }

    public static double meanOfDoubles(Collection<Double> values) {
        Preconditions.checkArgument((!values.isEmpty() ? 1 : 0) != 0, (Object)FAIL_MESSAGE);
        double sum = 0.0;
        for (double value : values) {
            sum += value;
        }
        return sum / (double)values.size();
    }

    public static double meanOfDoubles(double first, double ... rest) {
        return Averages.meanOfDoubles(Doubles.asList((double[])Doubles.concat((double[][])new double[][]{{first}, rest})));
    }
}

