/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.geomaps.utility;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Floats;
import java.awt.Color;
import java.awt.color.ColorSpace;
import java.util.Collection;
import java.util.List;

public class ColorTuples {
    public static final ColorSpace COLOR_SPACE = ColorSpace.getInstance(1000);
    public static final float DEFAULT_ALPHA = 1.0f;
    public static final Function<Float, Double> DOUBLE_VALUE_OF = new Function<Float, Double>(){

        public Double apply(Float f) {
            return f.doubleValue();
        }
    };
    public static final Function<Double, Float> FLOAT_VALUE_OF = new Function<Double, Float>(){

        public Float apply(Double d) {
            return Float.valueOf(d.floatValue());
        }
    };
    public static final Function<Color, double[]> AS_TUPLE = new Function<Color, double[]>(){

        public double[] apply(Color c) {
            return ColorTuples.asTuple(c);
        }
    };
    public static final Function<double[], Color> AS_COLOR = new Function<double[], Color>(){

        public Color apply(double[] t) {
            return ColorTuples.asColor(t);
        }
    };

    private ColorTuples() {
    }

    public static double[] asTuple(Color color) {
        float[] colorComponents = color.getColorComponents(COLOR_SPACE, null);
        return Doubles.toArray((Collection)Lists.transform((List)Floats.asList((float[])colorComponents), DOUBLE_VALUE_OF));
    }

    public static Color asColor(double[] tuple) {
        return new Color(COLOR_SPACE, Floats.toArray((Collection)Lists.transform((List)Doubles.asList((double[])tuple), FLOAT_VALUE_OF)), 1.0f);
    }
}

